/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.utils;

class TimerThread
extends Thread {
    private Object lock = new Object();
    private boolean exitFlag;
    private boolean waitingFlag;
    private boolean restartFlag;
    private long timeout;
    private Runnable callback;

    public TimerThread(long timeout, Runnable callback) {
        this.callback = callback;
        this.timeout = timeout;
        this.exitFlag = false;
        this.waitingFlag = true;
        this.restartFlag = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restartTimer() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (!this.isAlive() || !this.waitingFlag) break block4;
                this.restartFlag = true;
                this.interrupt();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer() {
        Object object = this.lock;
        synchronized (object) {
            this.exitFlag = true;
            if (this.waitingFlag) {
                this.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.waitingFlag) {
            if (this.exitFlag) {
                return;
            }
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.restartFlag) {
                    this.restartFlag = false;
                    this.waitingFlag = true;
                } else {
                    this.waitingFlag = false;
                }
            }
        }
        if (this.exitFlag) {
            return;
        }
        if (this.callback != null) {
            this.callback.run();
        }
    }
}

