/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.utils;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    public static final String EMPTY_STRING = "";
    public static final String NEW_LINE = String.format("%n", new Object[0]);
    public static final Pattern PATTERN_QUOTES_SINGLE = Pattern.compile("^'(.*)'$");
    public static final Pattern PATTERN_QUOTES_DOUBLE = Pattern.compile("^\"(.*)\"$");
    private static final Locale locale = Locale.ENGLISH;

    public static int compare(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return 0;
        }
        if (str1 == null && str2 != null) {
            return 1;
        }
        if (str1 != null && str2 == null) {
            return -1;
        }
        return str1.compareTo(str2);
    }

    public static int compareIgnoreCase(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return 0;
        }
        if (str1 == null && str2 != null) {
            return 1;
        }
        if (str1 != null && str2 == null) {
            return -1;
        }
        return str1.compareToIgnoreCase(str2);
    }

    public static boolean isEmpty(String str) {
        return !StringUtils.notEmpty(str);
    }

    public static boolean notEmpty(String ... str) {
        if (str != null) {
            String[] stringArray = str;
            int n = str.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!StringUtils.notEmpty(s)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public static boolean notEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static int length(String str) {
        return str != null ? str.length() : 0;
    }

    public static boolean equals(String str1, String str2) {
        return str1 != null && str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 != null && str1.equalsIgnoreCase(str2);
    }

    public static boolean equalsAny(String str1, String ... str2) {
        if (str1 != null && str2 != null) {
            String[] stringArray = str2;
            int n = str2.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (str1.equals(s)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean equalsAnyIgnoreCase(String str1, String ... str2) {
        if (str1 != null && str2 != null) {
            String[] stringArray = str2;
            int n = str2.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (str1.equalsIgnoreCase(s)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static String substring(String str, int len) {
        if (StringUtils.notEmpty(str)) {
            int n = str.length();
            return str.substring(0, len > n ? n : len);
        }
        return str;
    }

    public static String toLowerCase(String str) {
        if (StringUtils.notEmpty(str)) {
            return str.toLowerCase(locale);
        }
        return str;
    }

    public static String toUpperCase(String str) {
        if (StringUtils.notEmpty(str)) {
            return str.toUpperCase(locale);
        }
        return str;
    }

    public static String capitalize(String str) {
        if (StringUtils.notEmpty(str)) {
            return String.valueOf(str.substring(0, 1).toUpperCase(locale)) + str.substring(1);
        }
        return str;
    }

    public static String toString(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public static String nvl(String str) {
        return StringUtils.nvl(str, EMPTY_STRING);
    }

    public static String nvl(String str, String emptyValue) {
        if (StringUtils.notEmpty(str)) {
            return str;
        }
        return emptyValue;
    }

    public static String coalesce(String ... str) {
        if (str != null) {
            String[] stringArray = str;
            int n = str.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (StringUtils.notEmpty(s)) {
                    return s;
                }
                ++n2;
            }
        }
        return null;
    }

    public static String format(double value) {
        int intValue = (int)value;
        if (value == (double)intValue) {
            return String.format(locale, "%d", intValue);
        }
        return String.format(locale, "%s", value);
    }

    public static String format(Double value) {
        if (value != null) {
            int intValue = value.intValue();
            if (value == (double)intValue) {
                return String.format(locale, "%d", intValue);
            }
            return String.format(locale, "%s", value);
        }
        return null;
    }

    public static String format(Integer value) {
        if (value != null) {
            return String.format(locale, "%d", value);
        }
        return null;
    }

    public static String concat(List<String> tokens) {
        return StringUtils.concat(tokens, ",");
    }

    public static String concat(List<String> tokens, String delim) {
        if (tokens != null && delim != null) {
            StringBuilder sb = new StringBuilder(8192);
            for (String token : tokens) {
                if (sb.length() > 0) {
                    sb.append(delim);
                }
                sb.append(token);
            }
            return sb.toString();
        }
        return null;
    }

    public static int parseInt(String value, int errorValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception ignore) {
            return errorValue;
        }
    }

    public static Integer parseInteger(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static Double parseDouble(String value) {
        try {
            return Double.valueOf(value);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static String trim(String str) {
        return str != null ? str.trim() : null;
    }

    public static String trim2(String str) {
        if (StringUtils.notEmpty(str) && StringUtils.notEmpty(str = str.trim())) {
            return String.valueOf(str) + NEW_LINE;
        }
        return str;
    }

    public static boolean startsWith(String str, String prefix) {
        if (StringUtils.notEmpty(str)) {
            return str.startsWith(prefix);
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        if (StringUtils.notEmpty(str)) {
            return StringUtils.toLowerCase(str).startsWith(StringUtils.toLowerCase(prefix));
        }
        return false;
    }

    public static boolean endsWith(String str, String suffix) {
        return StringUtils.endsWith(str, suffix, false);
    }

    public static boolean endsWith(String str, String suffix, boolean ignoreWhitespace) {
        int n;
        if (StringUtils.notEmpty(str, suffix) && (n = str.lastIndexOf(suffix)) >= 0) {
            if ((n += suffix.length()) == str.length()) {
                return true;
            }
            if (ignoreWhitespace) {
                while (n < str.length()) {
                    if (Character.isWhitespace(str.charAt(n++))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean contains(String str, String substr) {
        if (StringUtils.notEmpty(str, substr)) {
            return str.contains(substr);
        }
        return false;
    }

    public static boolean matches(String str, String regex) {
        if (StringUtils.notEmpty(str, regex)) {
            return str.matches(regex);
        }
        return false;
    }

    public static String stripAccents(String str) {
        if (StringUtils.notEmpty(str)) {
            String nfd = Normalizer.normalize(str, Normalizer.Form.NFD);
            return nfd.replaceAll("\\p{InCombiningDiacriticalMarks}+", EMPTY_STRING);
        }
        return str;
    }

    public static String stripQuotes(String str) {
        return StringUtils.stripSingleQuotes(StringUtils.stripDoubleQuotes(str));
    }

    public static String stripSingleQuotes(String str) {
        Matcher matcher;
        if (StringUtils.notEmpty(str) && (matcher = PATTERN_QUOTES_SINGLE.matcher(str)).find()) {
            return matcher.group(1);
        }
        return str;
    }

    public static String stripDoubleQuotes(String str) {
        Matcher matcher;
        if (StringUtils.notEmpty(str) && (matcher = PATTERN_QUOTES_DOUBLE.matcher(str)).find()) {
            return matcher.group(1);
        }
        return str;
    }

    public static String create(byte[] bytes) {
        return StringUtils.create(bytes, null);
    }

    public static String create(byte[] bytes, Charset cs) {
        if (bytes != null) {
            return new String(bytes, cs != null ? cs : StandardCharsets.UTF_8);
        }
        return null;
    }

    public static String firstLine(String str) {
        int i;
        if (str != null && (i = str.indexOf(10)) >= 0) {
            return str.substring(0, i);
        }
        return str;
    }
}

