/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.utils;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bacza.utils.AssertUtils;

public final class StringEncoder {
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final int BLOCK_SIZE = 16;
    private static final String EMPTY_STRING = "";
    private final SecretKeySpec keySpec;

    public StringEncoder(String key) {
        AssertUtils.notNull(key, "key");
        byte[] keyBytes = key.getBytes(UTF_8);
        this.keySpec = new SecretKeySpec(this.getHash128(keyBytes), "AES");
    }

    private byte[] getHash128(byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash256 = digest.digest(bytes);
            byte[] hash128 = new byte[16];
            System.arraycopy(hash256, 0, hash128, 0, hash128.length);
            return hash128;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public byte[] encrypt(String data) throws IOException {
        AssertUtils.notNull(data, "data");
        byte[] iv = new byte[16];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, (Key)this.keySpec, ivSpec);
            byte[] encrypted = cipher.doFinal(data.getBytes(UTF_8));
            byte[] result = new byte[iv.length + encrypted.length];
            System.arraycopy(iv, 0, result, 0, iv.length);
            System.arraycopy(encrypted, 0, result, iv.length, encrypted.length);
            return result;
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public String decrypt(byte[] data) throws IOException {
        AssertUtils.notNull(data, "data");
        if (data.length == 0) {
            return EMPTY_STRING;
        }
        if (data.length < 16) {
            throw new IOException("Invalid data");
        }
        byte[] iv = new byte[16];
        System.arraycopy(data, 0, iv, 0, iv.length);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        int size = data.length - iv.length;
        byte[] encrypted = new byte[size];
        System.arraycopy(data, iv.length, encrypted, 0, size);
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, (Key)this.keySpec, ivSpec);
            byte[] decrypted = cipher.doFinal(encrypted);
            return new String(decrypted, UTF_8);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }
}

