/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.utils;

import java.awt.Desktop;
import java.net.URI;
import org.bacza.utils.OSUtils;

public final class DesktopUtils {
    public static boolean openUrl(String url) {
        try {
            if (DesktopUtils.isAvailable()) {
                Desktop.getDesktop().browse(URI.create(url));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isAvailable() {
        if (OSUtils.isWindows() || OSUtils.isMacOS()) {
            return Desktop.isDesktopSupported();
        }
        if (OSUtils.JAVA_SPEC_VERSION_NUM >= 10.0f) {
            return Desktop.isDesktopSupported();
        }
        return false;
    }
}

