/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;

public final class DateUtils {
    public static final String DATE_FORMAT_ISO = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String DATE_FORMAT_ISO_GMT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String DATE_FORMAT_ISO_EXT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String DATE_FORMAT_ISO_GMT_EXT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final TimeZone TZ_GMT = TimeZone.getTimeZone("GMT");
    public static final TimeZone TZ_LOCAL = TimeZone.getDefault();
    private static final DateFormat DATE_FORMAT_SHORT = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");

    public static final Date parseDate(String date, String format) {
        return DateUtils.parseDate(date, format, null);
    }

    public static final Date parseDateGMT(String date, String format) {
        return DateUtils.parseDate(date, format, TZ_GMT);
    }

    public static final Date parseDate(String date, String format, TimeZone zone) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        if (zone != null) {
            df.setTimeZone(zone);
        }
        return DateUtils.parseDate(date, df);
    }

    public static final Date parseDate(String date, DateFormat format) {
        if (format != null) {
            try {
                return format.parse(date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDateIso8601(String value) {
        Date result = null;
        if (value != null) {
            try {
                DateFormat dateFormat = df;
                synchronized (dateFormat) {
                    result = df.parse(value);
                }
            }
            catch (ParseException e) {
                result = null;
            }
        }
        return result;
    }

    public static Date parseDateJson(String value) {
        Date result;
        block7: {
            result = null;
            if (value != null) {
                int indexM;
                int indexP;
                block8: {
                    if (!value.startsWith("/Date(") || !value.endsWith(")/")) break block7;
                    value = value.substring(6, value.length() - 2);
                    indexP = value.indexOf(43);
                    indexM = value.indexOf(45);
                    if (indexP <= 0 || indexM <= 0) break block8;
                    return null;
                }
                try {
                    int index = indexP > 0 ? indexP : indexM;
                    String ts = null;
                    String tz = null;
                    if (index > 0) {
                        ts = value.substring(0, index);
                        tz = value.substring(index + 1);
                    } else {
                        ts = value;
                        tz = null;
                    }
                    long milisec = Long.parseLong(ts);
                    if (tz != null && tz.length() == 4) {
                        long h = Long.parseLong(tz.substring(0, 2));
                        long m = Long.parseLong(tz.substring(2));
                        h = h * 60L * 60L * 1000L;
                        m = m * 60L * 100L;
                        milisec = indexP > 0 ? (milisec += h) : (milisec -= (h += m));
                    }
                    result = new Date(milisec);
                }
                catch (Exception e) {
                    result = null;
                }
            }
        }
        return result;
    }

    public static Date parseDateLong(Long value) {
        Date result = null;
        if (value != null) {
            Date now = new Date(value);
            return now;
        }
        return result;
    }

    public static long getDateDiff(Date date1, Date date2, TimeUnit timeUnit) {
        long diffInMillies = (date2 != null ? date2.getTime() : Long.MAX_VALUE) - (date1 != null ? date1.getTime() : 0L);
        return timeUnit.convert(diffInMillies, TimeUnit.MILLISECONDS);
    }

    public static double getDaysBetween(Date date1, Date date2) {
        return (double)DateUtils.getDateDiff(date1, date2, TimeUnit.SECONDS) / 86400.0;
    }

    public static double getHoursBetween(Date date1, Date date2) {
        return (double)DateUtils.getDateDiff(date1, date2, TimeUnit.SECONDS) / 3600.0;
    }

    public static double getMinutesBetween(Date date1, Date date2) {
        return (double)DateUtils.getDateDiff(date1, date2, TimeUnit.SECONDS) / 60.0;
    }

    public static double getSecondsBetween(Date date1, Date date2) {
        return (double)DateUtils.getDateDiff(date1, date2, TimeUnit.MILLISECONDS) / 1000.0;
    }

    public static String formatDate(Date date, String format) {
        return DateUtils.formatDate(date, format, null, null);
    }

    public static String formatDate(Date date, String format, String timezone) {
        return DateUtils.formatDate(date, format, timezone, null);
    }

    public static String formatDate(Date date, String format, Locale locale) {
        return DateUtils.formatDate(date, format, null, locale);
    }

    public static String formatDate(Date date, String format, String timezone, Locale locale) {
        String result = null;
        if (date != null && StringUtils.notEmpty(format)) {
            try {
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                SimpleDateFormat df = new SimpleDateFormat(format, locale);
                if (StringUtils.notEmpty(timezone)) {
                    df.setTimeZone(TimeZone.getTimeZone(timezone));
                }
                result = df.format(date);
            }
            catch (Exception e) {
                result = null;
            }
        }
        return result;
    }

    public static String formatDate(Date date) {
        if (date != null) {
            return DATE_FORMAT_SHORT.format(date);
        }
        return null;
    }

    public static String formatDateGMT(Date date) {
        return DateUtils.formatDate(date, DATE_FORMAT_ISO_GMT, "GMT", Locale.UK);
    }

    public static String formatDateGMTExt(Date date) {
        return DateUtils.formatDate(date, DATE_FORMAT_ISO_GMT_EXT, "GMT", Locale.UK);
    }

    public static String getCurrentTimestamp() {
        return DateUtils.formatDate(new Date(), "yyyyMMdd-HHmmssSSS");
    }

    public static Date setDateOnly(Date date, Date newDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        Calendar calNew = Calendar.getInstance();
        calNew.setTime(newDate);
        cal.set(calNew.get(1), calNew.get(2), calNew.get(5));
        return cal.getTime();
    }

    public static Date truncate(Date date) {
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        return null;
    }

    public static Date addMiliseconds(Date date, long miliseconds) {
        if (date != null) {
            return new Date(date.getTime() + miliseconds);
        }
        return null;
    }

    public static Date addSeconds(Date date, long seconds) {
        return DateUtils.addMiliseconds(date, seconds * 1000L);
    }

    public static Date addMinutes(Date date, long minutes) {
        return DateUtils.addMiliseconds(date, minutes * 60000L);
    }

    public static Date addHours(Date date, long hours) {
        return DateUtils.addMiliseconds(date, hours * 3600000L);
    }

    public static boolean hasExpired(Date date) {
        if (date != null) {
            return System.currentTimeMillis() > date.getTime();
        }
        return false;
    }

    public static Date convertTimeZone(Date date, TimeZone tz1, TimeZone tz2) {
        if (date != null) {
            AssertUtils.notNull(tz1, "tz1");
            AssertUtils.notNull(tz2, "tz2");
            GregorianCalendar cal1 = new GregorianCalendar(tz2);
            GregorianCalendar cal2 = new GregorianCalendar(tz1);
            cal1.setTime(date);
            cal2.set(1, cal1.get(1));
            cal2.set(2, cal1.get(2));
            cal2.set(5, cal1.get(5));
            cal2.set(11, cal1.get(11));
            cal2.set(12, cal1.get(12));
            cal2.set(13, cal1.get(13));
            cal2.set(14, cal1.get(14));
            return cal2.getTime();
        }
        return null;
    }
}

