/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.bacza.utils.AssertUtils;

public class DateFormatHelper {
    private final SimpleDateFormat df;

    public DateFormatHelper(String format) {
        this(format, TimeZone.getDefault());
    }

    public DateFormatHelper(String format, TimeZone tz) {
        this(format, tz, Locale.UK);
    }

    public DateFormatHelper(String format, TimeZone tz, Locale locale) {
        AssertUtils.notNull(format, "Format");
        AssertUtils.notNull(tz, "Time zone");
        AssertUtils.notNull(locale, "Locale");
        this.df = new SimpleDateFormat(format, locale);
        this.df.setTimeZone(tz);
    }

    public SimpleDateFormat getDateFormat() {
        return this.df;
    }

    public Date parse(String str) {
        try {
            return this.df.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String format(Date date) {
        return this.df.format(date);
    }
}

