/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.http;

import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.bacza.http.WebExecutor;
import org.bacza.http.WebResponse;
import org.bacza.utils.AssertUtils;

public class WebClient {
    private final OkHttpClient httpClient;
    private final WebExecutor executor;

    public WebClient(OkHttpClient httpClient) {
        this(httpClient, new WebExecutor());
    }

    public WebClient(OkHttpClient httpClient, WebExecutor executor) {
        AssertUtils.notNull(httpClient, "HTTP client");
        AssertUtils.notNull(executor, "Executor");
        this.httpClient = httpClient;
        this.executor = executor;
    }

    public WebClient newClient(WebExecutor executor) {
        AssertUtils.notNull(executor, "Executor");
        return new WebClient(this.httpClient, executor);
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public WebResponse execute(Request request) throws IOException {
        return this.executor.execute(this.httpClient, request);
    }
}

