/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.http;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;

public final class URLUtils {
    public static Map<String, String> getParams(String url) {
        if (StringUtils.notEmpty(url = URLUtils.decode(url))) {
            String[] params;
            HashMap<String, String> result = new HashMap<String, String>();
            int i = url.indexOf(63);
            if (i > 0 && (params = url.substring(i + 1).split("&|=|#")) != null) {
                i = 0;
                while (i < params.length) {
                    String name = params[i];
                    String value = i + 1 < params.length ? params[i + 1] : "";
                    result.put(name, value);
                    i += 2;
                }
            }
            return result;
        }
        return null;
    }

    public static String getParamValue(String url, String paramName) {
        Map<String, String> params;
        if (StringUtils.notEmpty(url, paramName) && (params = URLUtils.getParams(url)) != null) {
            return params.get(paramName);
        }
        return null;
    }

    public static boolean hasParam(String url, String paramName) {
        Map<String, String> params;
        if (StringUtils.notEmpty(url, paramName) && (params = URLUtils.getParams(url)) != null) {
            return params.containsKey(paramName);
        }
        return false;
    }

    public static String decode(String str) {
        if (str != null) {
            try {
                return URLDecoder.decode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return str;
    }

    public static URI abs(URI base, String relative) {
        AssertUtils.notNull(base, "Base");
        AssertUtils.notNull(relative, "Relative");
        relative = relative.trim();
        if (StringUtils.notEmpty(relative)) {
            base = base.resolve(relative);
        }
        return base;
    }

    public static URI abs(String base, String relative) {
        return URLUtils.abs(URLUtils.create(base), relative);
    }

    public static String absAsString(URI base, String relative) {
        return URLUtils.toASCIIString(URLUtils.abs(base, relative));
    }

    public static String absAsString(String base, String relative) {
        return URLUtils.toASCIIString(URLUtils.abs(base, relative));
    }

    public static String toASCIIString(URI uri) {
        if (uri != null) {
            return uri.toASCIIString();
        }
        return null;
    }

    public static URI create(String uri) {
        if (uri != null) {
            return URI.create(uri);
        }
        return null;
    }

    public static String stripProtocol(String url) {
        if (StringUtils.notEmpty(url)) {
            url = url.replaceFirst("http(s)?://", "");
        }
        return url;
    }
}

