/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.http;

import java.io.IOException;
import java.net.URI;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;

public final class ResponseUtils {
    public static URI getLastURI(Response response) {
        HttpUrl url;
        AssertUtils.notNull(response, "HTTP response");
        Request request = response.request();
        if (request != null && (url = request.url()) != null) {
            return url.uri();
        }
        return null;
    }

    public static String getContentType(Response response) {
        MediaType contentType;
        AssertUtils.notNull(response, "HTTP response");
        ResponseBody body = response.body();
        if (body != null && (contentType = response.body().contentType()) != null) {
            return String.format("%s/%s", contentType.type(), contentType.subtype());
        }
        return null;
    }

    public static String getContentText(Response response) throws IOException {
        AssertUtils.notNull(response, "HTTP response");
        ResponseBody body = response.body();
        if (body != null) {
            return body.string();
        }
        return null;
    }

    public static boolean isHtmlResponse(Response response) {
        return ResponseUtils.isHtmlResponse(ResponseUtils.getContentType(response));
    }

    public static boolean isHtmlResponse(String contentType) {
        return StringUtils.startsWithIgnoreCase(contentType, "text/html");
    }

    public static boolean isJsonResponse(Response response) {
        return ResponseUtils.isJsonResponse(ResponseUtils.getContentType(response));
    }

    public static boolean isJsonResponse(String contentType) {
        return StringUtils.startsWithIgnoreCase(contentType, "application/json");
    }
}

