/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.http;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import org.bacza.utils.StringUtils;

public abstract class PersistentCookieJar
implements CookieJar,
Closeable {
    private Map<String, Cookie> cookiesById = new HashMap<String, Cookie>();
    private List<Cookie> overrides = new LinkedList<Cookie>();
    private boolean loading = false;

    protected String getCookieId(Cookie cookie) {
        if (cookie != null) {
            String domain = cookie.domain();
            String name = cookie.name();
            if (StringUtils.notEmpty(domain) && StringUtils.notEmpty(name)) {
                return String.valueOf(cookie.secure() ? "https" : "http") + "://" + cookie.domain() + cookie.path() + "|" + cookie.name();
            }
        }
        return null;
    }

    public synchronized void addOverride(Cookie cookie) {
        this.addCookieImpl(cookie, true);
        this.overrides.add(cookie);
    }

    public synchronized List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookiesById.values());
    }

    public synchronized List<Cookie> loadForRequest(HttpUrl url) {
        ArrayList<Cookie> result = new ArrayList<Cookie>(32);
        Iterator<Map.Entry<String, Cookie>> iter = this.cookiesById.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Cookie> entry = iter.next();
            Cookie cookie = entry.getValue();
            if (this.isExpired(cookie)) {
                if (!this.loading) {
                    this.onCookieRemove(cookie);
                }
                iter.remove();
                continue;
            }
            if (!cookie.matches(url)) continue;
            result.add(cookie);
        }
        return result;
    }

    public synchronized void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                this.addCookie(cookie);
            }
        }
    }

    public synchronized void addCookie(Cookie cookie) {
        this.addCookieImpl(cookie, false);
    }

    protected synchronized void addCookieImpl(Cookie cookie, boolean force) {
        String id = this.getCookieId(cookie);
        if (StringUtils.notEmpty(id)) {
            Cookie c;
            if (!force) {
                for (Cookie override : this.overrides) {
                    if (!cookie.name().equals(override.name()) || !cookie.domain().endsWith(override.domain())) continue;
                    return;
                }
            }
            if ((c = this.cookiesById.get(id)) == null) {
                if (!this.isExpired(cookie)) {
                    this.cookiesById.put(id, cookie);
                    if (!this.loading) {
                        this.onCookieAdd(cookie);
                    }
                }
            } else if (this.isExpired(cookie)) {
                if (!this.loading) {
                    this.onCookieRemove(cookie);
                }
                this.cookiesById.remove(id);
            } else if (!c.toString().equals(cookie.toString())) {
                this.cookiesById.put(id, cookie);
                if (!this.loading) {
                    this.onCookieUpdate(cookie);
                }
            }
        }
    }

    public synchronized void clear() {
        this.cookiesById.clear();
        if (!this.loading) {
            this.onClear();
        }
    }

    private boolean isExpired(Cookie cookie) {
        return cookie.expiresAt() < System.currentTimeMillis();
    }

    public void load() throws IOException {
        try {
            this.loading = true;
            this.onLoad();
        }
        finally {
            this.loading = false;
        }
    }

    @Override
    public void close() throws IOException {
        this.onClose();
    }

    protected abstract void onLoad() throws IOException;

    protected abstract void onClose() throws IOException;

    protected abstract void onCookieAdd(Cookie var1);

    protected abstract void onCookieUpdate(Cookie var1);

    protected abstract void onCookieRemove(Cookie var1);

    protected abstract void onClear();
}

