/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.http;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class MIMEUtils {
    public static final Map<String, String> MIME_TYPES = MIMEUtils.getMimeTypes();
    public static final Set<String> TEXT_MIME_TYPES = MIMEUtils.getTextMimeTypes();

    private static Map<String, String> getMimeTypes() {
        HashMap<String, String> mimeTypes = new HashMap<String, String>();
        mimeTypes.put("application/andrew-inset", "");
        mimeTypes.put("application/applixware", ".aw");
        mimeTypes.put("application/atom+xml", ".atom, .xml");
        mimeTypes.put("application/atomcat+xml", ".atomcat");
        mimeTypes.put("application/atomsvc+xml", ".atomsvc");
        mimeTypes.put("application/ccxml+xml,", ".ccxml");
        mimeTypes.put("application/cdmi-capability", ".cdmia");
        mimeTypes.put("application/cdmi-container", ".cdmic");
        mimeTypes.put("application/cdmi-domain", ".cdmid");
        mimeTypes.put("application/cdmi-object", ".cdmio");
        mimeTypes.put("application/cdmi-queue", ".cdmiq");
        mimeTypes.put("application/cu-seeme", ".cu");
        mimeTypes.put("application/davmount+xml", ".davmount");
        mimeTypes.put("application/dssc+der", ".dssc");
        mimeTypes.put("application/dssc+xml", ".xdssc");
        mimeTypes.put("application/ecmascript", ".es");
        mimeTypes.put("application/emma+xml", ".emma");
        mimeTypes.put("application/epub+zip", ".epub");
        mimeTypes.put("application/exi", ".exi");
        mimeTypes.put("application/font-tdpfr", ".pfr");
        mimeTypes.put("application/hyperstudio", ".stk");
        mimeTypes.put("application/ipfix", ".ipfix");
        mimeTypes.put("application/java-archive", ".jar");
        mimeTypes.put("application/java-serialized-object", ".ser");
        mimeTypes.put("application/java-vm", ".class");
        mimeTypes.put("application/javascript", ".js");
        mimeTypes.put("application/json", ".json");
        mimeTypes.put("application/mac-binhex40", ".hqx");
        mimeTypes.put("application/mac-compactpro", ".cpt");
        mimeTypes.put("application/mads+xml", ".mads");
        mimeTypes.put("application/marc", ".mrc");
        mimeTypes.put("application/marcxml+xml", ".mrcx");
        mimeTypes.put("application/mathematica", ".ma");
        mimeTypes.put("application/mathml+xml", ".mathml");
        mimeTypes.put("application/mbox", ".mbox");
        mimeTypes.put("application/mediaservercontrol+xml", ".mscml");
        mimeTypes.put("application/metalink4+xml", ".meta4");
        mimeTypes.put("application/mets+xml", ".mets");
        mimeTypes.put("application/mods+xml", ".mods");
        mimeTypes.put("application/mp21", ".m21");
        mimeTypes.put("application/mp4", ".mp4");
        mimeTypes.put("application/msword", ".doc");
        mimeTypes.put("application/mxf", ".mxf");
        mimeTypes.put("application/octet-stream", ".bin");
        mimeTypes.put("application/oda", ".oda");
        mimeTypes.put("application/oebps-package+xml", ".opf");
        mimeTypes.put("application/ogg", ".ogx");
        mimeTypes.put("application/onenote", ".onetoc");
        mimeTypes.put("application/patch-ops-error+xml", ".xer");
        mimeTypes.put("application/pdf", ".pdf");
        mimeTypes.put("application/pgp-encrypted", "");
        mimeTypes.put("application/pgp-signature", ".pgp");
        mimeTypes.put("application/pics-rules", ".prf");
        mimeTypes.put("application/pkcs10", ".p10");
        mimeTypes.put("application/pkcs7-mime", ".p7m");
        mimeTypes.put("application/pkcs7-signature", ".p7s");
        mimeTypes.put("application/pkcs8", ".p8");
        mimeTypes.put("application/pkix-attr-cert", ".ac");
        mimeTypes.put("application/pkix-cert", ".cer");
        mimeTypes.put("application/pkix-crl", ".crl");
        mimeTypes.put("application/pkix-pkipath", ".pkipath");
        mimeTypes.put("application/pkixcmp", ".pki");
        mimeTypes.put("application/pls+xml", ".pls");
        mimeTypes.put("application/postscript", ".ai");
        mimeTypes.put("application/prs.cww", ".cww");
        mimeTypes.put("application/pskc+xml", ".pskcxml");
        mimeTypes.put("application/rdf+xml", ".rdf");
        mimeTypes.put("application/reginfo+xml", ".rif");
        mimeTypes.put("application/relax-ng-compact-syntax", ".rnc");
        mimeTypes.put("application/resource-lists+xml", ".rl");
        mimeTypes.put("application/resource-lists-diff+xml", ".rld");
        mimeTypes.put("application/rls-services+xml", ".rs");
        mimeTypes.put("application/rsd+xml", ".rsd");
        mimeTypes.put("application/rss+xml", ".rss, .xml");
        mimeTypes.put("application/rtf", ".rtf");
        mimeTypes.put("application/sbml+xml", ".sbml");
        mimeTypes.put("application/scvp-cv-request", ".scq");
        mimeTypes.put("application/scvp-cv-response", ".scs");
        mimeTypes.put("application/scvp-vp-request", ".spq");
        mimeTypes.put("application/scvp-vp-response", ".spp");
        mimeTypes.put("application/sdp", ".sdp");
        mimeTypes.put("application/set-payment-initiation", ".setpay");
        mimeTypes.put("application/set-registration-initiation", ".setreg");
        mimeTypes.put("application/shf+xml", ".shf");
        mimeTypes.put("application/smil+xml", ".smi");
        mimeTypes.put("application/sparql-query", ".rq");
        mimeTypes.put("application/sparql-results+xml", ".srx");
        mimeTypes.put("application/srgs", ".gram");
        mimeTypes.put("application/srgs+xml", ".grxml");
        mimeTypes.put("application/sru+xml", ".sru");
        mimeTypes.put("application/ssml+xml", ".ssml");
        mimeTypes.put("application/tei+xml", ".tei");
        mimeTypes.put("application/thraud+xml", ".tfi");
        mimeTypes.put("application/timestamped-data", ".tsd");
        mimeTypes.put("application/vnd.3gpp.pic-bw-large", ".plb");
        mimeTypes.put("application/vnd.3gpp.pic-bw-small", ".psb");
        mimeTypes.put("application/vnd.3gpp.pic-bw-var", ".pvb");
        mimeTypes.put("application/vnd.3gpp2.tcap", ".tcap");
        mimeTypes.put("application/vnd.3m.post-it-notes", ".pwn");
        mimeTypes.put("application/vnd.accpac.simply.aso", ".aso");
        mimeTypes.put("application/vnd.accpac.simply.imp", ".imp");
        mimeTypes.put("application/vnd.acucobol", ".acu");
        mimeTypes.put("application/vnd.acucorp", ".atc");
        mimeTypes.put("application/vnd.adobe.air-application-installer-package+zip", ".air");
        mimeTypes.put("application/vnd.adobe.fxp", ".fxp");
        mimeTypes.put("application/vnd.adobe.xdp+xml", ".xdp");
        mimeTypes.put("application/vnd.adobe.xfdf", ".xfdf");
        mimeTypes.put("application/vnd.ahead.space", ".ahead");
        mimeTypes.put("application/vnd.airzip.filesecure.azf", ".azf");
        mimeTypes.put("application/vnd.airzip.filesecure.azs", ".azs");
        mimeTypes.put("application/vnd.amazon.ebook", ".azw");
        mimeTypes.put("application/vnd.americandynamics.acc", ".acc");
        mimeTypes.put("application/vnd.amiga.ami", ".ami");
        mimeTypes.put("application/vnd.android.package-archive", ".apk");
        mimeTypes.put("application/vnd.anser-web-certificate-issue-initiation", ".cii");
        mimeTypes.put("application/vnd.anser-web-funds-transfer-initiation", ".fti");
        mimeTypes.put("application/vnd.antix.game-component", ".atx");
        mimeTypes.put("application/vnd.apple.installer+xml", ".mpkg");
        mimeTypes.put("application/vnd.apple.mpegurl", ".m3u8");
        mimeTypes.put("application/vnd.aristanetworks.swi", ".swi");
        mimeTypes.put("application/vnd.audiograph", ".aep");
        mimeTypes.put("application/vnd.blueice.multipass", ".mpm");
        mimeTypes.put("application/vnd.bmi", ".bmi");
        mimeTypes.put("application/vnd.businessobjects", ".rep");
        mimeTypes.put("application/vnd.chemdraw+xml", ".cdxml");
        mimeTypes.put("application/vnd.chipnuts.karaoke-mmd", ".mmd");
        mimeTypes.put("application/vnd.cinderella", ".cdy");
        mimeTypes.put("application/vnd.claymore", ".cla");
        mimeTypes.put("application/vnd.cloanto.rp9", ".rp9");
        mimeTypes.put("application/vnd.clonk.c4group", ".c4g");
        mimeTypes.put("application/vnd.cluetrust.cartomobile-config", ".c11amc");
        mimeTypes.put("application/vnd.cluetrust.cartomobile-config-pkg", ".c11amz");
        mimeTypes.put("application/vnd.commonspace", ".csp");
        mimeTypes.put("application/vnd.contact.cmsg", ".cdbcmsg");
        mimeTypes.put("application/vnd.cosmocaller", ".cmc");
        mimeTypes.put("application/vnd.crick.clicker", ".clkx");
        mimeTypes.put("application/vnd.crick.clicker.keyboard", ".clkk");
        mimeTypes.put("application/vnd.crick.clicker.palette", ".clkp");
        mimeTypes.put("application/vnd.crick.clicker.template", ".clkt");
        mimeTypes.put("application/vnd.crick.clicker.wordbank", ".clkw");
        mimeTypes.put("application/vnd.criticaltools.wbs+xml", ".wbs");
        mimeTypes.put("application/vnd.ctc-posml", ".pml");
        mimeTypes.put("application/vnd.cups-ppd", ".ppd");
        mimeTypes.put("application/vnd.curl.car", ".car");
        mimeTypes.put("application/vnd.curl.pcurl", ".pcurl");
        mimeTypes.put("application/vnd.data-vision.rdz", ".rdz");
        mimeTypes.put("application/vnd.denovo.fcselayout-link", ".fe_launch");
        mimeTypes.put("application/vnd.dna", ".dna");
        mimeTypes.put("application/vnd.dolby.mlp", ".mlp");
        mimeTypes.put("application/vnd.dpgraph", ".dpg");
        mimeTypes.put("application/vnd.dreamfactory", ".dfac");
        mimeTypes.put("application/vnd.dvb.ait", ".ait");
        mimeTypes.put("application/vnd.dvb.service", ".svc");
        mimeTypes.put("application/vnd.dynageo", ".geo");
        mimeTypes.put("application/vnd.ecowin.chart", ".mag");
        mimeTypes.put("application/vnd.enliven", ".nml");
        mimeTypes.put("application/vnd.epson.esf", ".esf");
        mimeTypes.put("application/vnd.epson.msf", ".msf");
        mimeTypes.put("application/vnd.epson.quickanime", ".qam");
        mimeTypes.put("application/vnd.epson.salt", ".slt");
        mimeTypes.put("application/vnd.epson.ssf", ".ssf");
        mimeTypes.put("application/vnd.eszigno3+xml", ".es3");
        mimeTypes.put("application/vnd.ezpix-album", ".ez2");
        mimeTypes.put("application/vnd.ezpix-package", ".ez3");
        mimeTypes.put("application/vnd.fdf", ".fdf");
        mimeTypes.put("application/vnd.fdsn.seed", ".seed");
        mimeTypes.put("application/vnd.flographit", ".gph");
        mimeTypes.put("application/vnd.fluxtime.clip", ".ftc");
        mimeTypes.put("application/vnd.framemaker", ".fm");
        mimeTypes.put("application/vnd.frogans.fnc", ".fnc");
        mimeTypes.put("application/vnd.frogans.ltf", ".ltf");
        mimeTypes.put("application/vnd.fsc.weblaunch", ".fsc");
        mimeTypes.put("application/vnd.fujitsu.oasys", ".oas");
        mimeTypes.put("application/vnd.fujitsu.oasys2", ".oa2");
        mimeTypes.put("application/vnd.fujitsu.oasys3", ".oa3");
        mimeTypes.put("application/vnd.fujitsu.oasysgp", ".fg5");
        mimeTypes.put("application/vnd.fujitsu.oasysprs", ".bh2");
        mimeTypes.put("application/vnd.fujixerox.ddd", ".ddd");
        mimeTypes.put("application/vnd.fujixerox.docuworks", ".xdw");
        mimeTypes.put("application/vnd.fujixerox.docuworks.binder", ".xbd");
        mimeTypes.put("application/vnd.fuzzysheet", ".fzs");
        mimeTypes.put("application/vnd.genomatix.tuxedo", ".txd");
        mimeTypes.put("application/vnd.geogebra.file", ".ggb");
        mimeTypes.put("application/vnd.geogebra.tool", ".ggt");
        mimeTypes.put("application/vnd.geometry-explorer", ".gex");
        mimeTypes.put("application/vnd.geonext", ".gxt");
        mimeTypes.put("application/vnd.geoplan", ".g2w");
        mimeTypes.put("application/vnd.geospace", ".g3w");
        mimeTypes.put("application/vnd.gmx", ".gmx");
        mimeTypes.put("application/vnd.google-earth.kml+xml", ".kml");
        mimeTypes.put("application/vnd.google-earth.kmz", ".kmz");
        mimeTypes.put("application/vnd.grafeq", ".gqf");
        mimeTypes.put("application/vnd.groove-account", ".gac");
        mimeTypes.put("application/vnd.groove-help", ".ghf");
        mimeTypes.put("application/vnd.groove-identity-message", ".gim");
        mimeTypes.put("application/vnd.groove-injector", ".grv");
        mimeTypes.put("application/vnd.groove-tool-message", ".gtm");
        mimeTypes.put("application/vnd.groove-tool-template", ".tpl");
        mimeTypes.put("application/vnd.groove-vcard", ".vcg");
        mimeTypes.put("application/vnd.hal+xml", ".hal");
        mimeTypes.put("application/vnd.handheld-entertainment+xml", ".zmm");
        mimeTypes.put("application/vnd.hbci", ".hbci");
        mimeTypes.put("application/vnd.hhe.lesson-player", ".les");
        mimeTypes.put("application/vnd.hp-hpgl", ".hpgl");
        mimeTypes.put("application/vnd.hp-hpid", ".hpid");
        mimeTypes.put("application/vnd.hp-hps", ".hps");
        mimeTypes.put("application/vnd.hp-jlyt", ".jlt");
        mimeTypes.put("application/vnd.hp-pcl", ".pcl");
        mimeTypes.put("application/vnd.hp-pclxl", ".pclxl");
        mimeTypes.put("application/vnd.hydrostatix.sof-data", ".sfd-hdstx");
        mimeTypes.put("application/vnd.hzn-3d-crossword", ".x3d");
        mimeTypes.put("application/vnd.ibm.minipay", ".mpy");
        mimeTypes.put("application/vnd.ibm.modcap", ".afp");
        mimeTypes.put("application/vnd.ibm.rights-management", ".irm");
        mimeTypes.put("application/vnd.ibm.secure-container", ".sc");
        mimeTypes.put("application/vnd.iccprofile", ".icc");
        mimeTypes.put("application/vnd.igloader", ".igl");
        mimeTypes.put("application/vnd.immervision-ivp", ".ivp");
        mimeTypes.put("application/vnd.immervision-ivu", ".ivu");
        mimeTypes.put("application/vnd.insors.igm", ".igm");
        mimeTypes.put("application/vnd.intercon.formnet", ".xpw");
        mimeTypes.put("application/vnd.intergeo", ".i2g");
        mimeTypes.put("application/vnd.intu.qbo", ".qbo");
        mimeTypes.put("application/vnd.intu.qfx", ".qfx");
        mimeTypes.put("application/vnd.ipunplugged.rcprofile", ".rcprofile");
        mimeTypes.put("application/vnd.irepository.package+xml", ".irp");
        mimeTypes.put("application/vnd.is-xpr", ".xpr");
        mimeTypes.put("application/vnd.isac.fcs", ".fcs");
        mimeTypes.put("application/vnd.jam", ".jam");
        mimeTypes.put("application/vnd.jcp.javame.midlet-rms", ".rms");
        mimeTypes.put("application/vnd.jisp", ".jisp");
        mimeTypes.put("application/vnd.joost.joda-archive", ".joda");
        mimeTypes.put("application/vnd.kahootz", ".ktz");
        mimeTypes.put("application/vnd.kde.karbon", ".karbon");
        mimeTypes.put("application/vnd.kde.kchart", ".chrt");
        mimeTypes.put("application/vnd.kde.kformula", ".kfo");
        mimeTypes.put("application/vnd.kde.kivio", ".flw");
        mimeTypes.put("application/vnd.kde.kontour", ".kon");
        mimeTypes.put("application/vnd.kde.kpresenter", ".kpr");
        mimeTypes.put("application/vnd.kde.kspread", ".ksp");
        mimeTypes.put("application/vnd.kde.kword", ".kwd");
        mimeTypes.put("application/vnd.kenameaapp", ".htke");
        mimeTypes.put("application/vnd.kidspiration", ".kia");
        mimeTypes.put("application/vnd.kinar", ".kne");
        mimeTypes.put("application/vnd.koan", ".skp");
        mimeTypes.put("application/vnd.kodak-descriptor", ".sse");
        mimeTypes.put("application/vnd.las.las+xml", ".lasxml");
        mimeTypes.put("application/vnd.llamagraphics.life-balance.desktop", ".lbd");
        mimeTypes.put("application/vnd.llamagraphics.life-balance.exchange+xml", ".lbe");
        mimeTypes.put("application/vnd.lotus-1-2-3", "0.123");
        mimeTypes.put("application/vnd.lotus-approach", ".apr");
        mimeTypes.put("application/vnd.lotus-freelance", ".pre");
        mimeTypes.put("application/vnd.lotus-notes", ".nsf");
        mimeTypes.put("application/vnd.lotus-organizer", ".org");
        mimeTypes.put("application/vnd.lotus-screencam", ".scm");
        mimeTypes.put("application/vnd.lotus-wordpro", ".lwp");
        mimeTypes.put("application/vnd.macports.portpkg", ".portpkg");
        mimeTypes.put("application/vnd.mcd", ".mcd");
        mimeTypes.put("application/vnd.medcalcdata", ".mc1");
        mimeTypes.put("application/vnd.mediastation.cdkey", ".cdkey");
        mimeTypes.put("application/vnd.mfer", ".mwf");
        mimeTypes.put("application/vnd.mfmp", ".mfm");
        mimeTypes.put("application/vnd.micrografx.flo", ".flo");
        mimeTypes.put("application/vnd.micrografx.igx", ".igx");
        mimeTypes.put("application/vnd.mif", ".mif");
        mimeTypes.put("application/vnd.mobius.daf", ".daf");
        mimeTypes.put("application/vnd.mobius.dis", ".dis");
        mimeTypes.put("application/vnd.mobius.mbk", ".mbk");
        mimeTypes.put("application/vnd.mobius.mqy", ".mqy");
        mimeTypes.put("application/vnd.mobius.msl", ".msl");
        mimeTypes.put("application/vnd.mobius.plc", ".plc");
        mimeTypes.put("application/vnd.mobius.txf", ".txf");
        mimeTypes.put("application/vnd.mophun.application", ".mpn");
        mimeTypes.put("application/vnd.mophun.certificate", ".mpc");
        mimeTypes.put("application/vnd.mozilla.xul+xml", ".xul");
        mimeTypes.put("application/vnd.ms-artgalry", ".cil");
        mimeTypes.put("application/vnd.ms-cab-compressed", ".cab");
        mimeTypes.put("application/vnd.ms-excel", ".xls");
        mimeTypes.put("application/vnd.ms-excel.addin.macroenabled.12", ".xlam");
        mimeTypes.put("application/vnd.ms-excel.sheet.binary.macroenabled.12", ".xlsb");
        mimeTypes.put("application/vnd.ms-excel.sheet.macroenabled.12", ".xlsm");
        mimeTypes.put("application/vnd.ms-excel.template.macroenabled.12", ".xltm");
        mimeTypes.put("application/vnd.ms-fontobject", ".eot");
        mimeTypes.put("application/vnd.ms-htmlhelp", ".chm");
        mimeTypes.put("application/vnd.ms-ims", ".ims");
        mimeTypes.put("application/vnd.ms-lrm", ".lrm");
        mimeTypes.put("application/vnd.ms-officetheme", ".thmx");
        mimeTypes.put("application/vnd.ms-pki.seccat", ".cat");
        mimeTypes.put("application/vnd.ms-pki.stl", ".stl");
        mimeTypes.put("application/vnd.ms-powerpoint", ".ppt");
        mimeTypes.put("application/vnd.ms-powerpoint.addin.macroenabled.12", ".ppam");
        mimeTypes.put("application/vnd.ms-powerpoint.presentation.macroenabled.12", ".pptm");
        mimeTypes.put("application/vnd.ms-powerpoint.slide.macroenabled.12", ".sldm");
        mimeTypes.put("application/vnd.ms-powerpoint.slideshow.macroenabled.12", ".ppsm");
        mimeTypes.put("application/vnd.ms-powerpoint.template.macroenabled.12", ".potm");
        mimeTypes.put("application/vnd.ms-project", ".mpp");
        mimeTypes.put("application/vnd.ms-word.document.macroenabled.12", ".docm");
        mimeTypes.put("application/vnd.ms-word.template.macroenabled.12", ".dotm");
        mimeTypes.put("application/vnd.ms-works", ".wps");
        mimeTypes.put("application/vnd.ms-wpl", ".wpl");
        mimeTypes.put("application/vnd.ms-xpsdocument", ".xps");
        mimeTypes.put("application/vnd.mseq", ".mseq");
        mimeTypes.put("application/vnd.musician", ".mus");
        mimeTypes.put("application/vnd.muvee.style", ".msty");
        mimeTypes.put("application/vnd.neurolanguage.nlu", ".nlu");
        mimeTypes.put("application/vnd.noblenet-directory", ".nnd");
        mimeTypes.put("application/vnd.noblenet-sealer", ".nns");
        mimeTypes.put("application/vnd.noblenet-web", ".nnw");
        mimeTypes.put("application/vnd.nokia.n-gage.data", ".ngdat");
        mimeTypes.put("application/vnd.nokia.n-gage.symbian.install", ".n-gage");
        mimeTypes.put("application/vnd.nokia.radio-preset", ".rpst");
        mimeTypes.put("application/vnd.nokia.radio-presets", ".rpss");
        mimeTypes.put("application/vnd.novadigm.edm", ".edm");
        mimeTypes.put("application/vnd.novadigm.edx", ".edx");
        mimeTypes.put("application/vnd.novadigm.ext", ".ext");
        mimeTypes.put("application/vnd.oasis.opendocument.chart", ".odc");
        mimeTypes.put("application/vnd.oasis.opendocument.chart-template", ".otc");
        mimeTypes.put("application/vnd.oasis.opendocument.database", ".odb");
        mimeTypes.put("application/vnd.oasis.opendocument.formula", ".odf");
        mimeTypes.put("application/vnd.oasis.opendocument.formula-template", ".odft");
        mimeTypes.put("application/vnd.oasis.opendocument.graphics", ".odg");
        mimeTypes.put("application/vnd.oasis.opendocument.graphics-template", ".otg");
        mimeTypes.put("application/vnd.oasis.opendocument.image", ".odi");
        mimeTypes.put("application/vnd.oasis.opendocument.image-template", ".oti");
        mimeTypes.put("application/vnd.oasis.opendocument.presentation", ".odp");
        mimeTypes.put("application/vnd.oasis.opendocument.presentation-template", ".otp");
        mimeTypes.put("application/vnd.oasis.opendocument.spreadsheet", ".ods");
        mimeTypes.put("application/vnd.oasis.opendocument.spreadsheet-template", ".ots");
        mimeTypes.put("application/vnd.oasis.opendocument.text", ".odt");
        mimeTypes.put("application/vnd.oasis.opendocument.text-master", ".odm");
        mimeTypes.put("application/vnd.oasis.opendocument.text-template", ".ott");
        mimeTypes.put("application/vnd.oasis.opendocument.text-web", ".oth");
        mimeTypes.put("application/vnd.olpc-sugar", ".xo");
        mimeTypes.put("application/vnd.oma.dd2+xml", ".dd2");
        mimeTypes.put("application/vnd.openofficeorg.extension", ".oxt");
        mimeTypes.put("application/vnd.openxmlformats-officedocument.presentationml.presentation", ".pptx");
        mimeTypes.put("application/vnd.openxmlformats-officedocument.presentationml.slide", ".sldx");
        mimeTypes.put("application/vnd.openxmlformats-officedocument.presentationml.slideshow", ".ppsx");
        mimeTypes.put("application/vnd.openxmlformats-officedocument.presentationml.template", ".potx");
        mimeTypes.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", ".xlsx");
        mimeTypes.put("application/vnd.openxmlformats-officedocument.spreadsheetml.template", ".xltx");
        mimeTypes.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", ".docx");
        mimeTypes.put("application/vnd.openxmlformats-officedocument.wordprocessingml.template", ".dotx");
        mimeTypes.put("application/vnd.osgeo.mapguide.package", ".mgp");
        mimeTypes.put("application/vnd.osgi.dp", ".dp");
        mimeTypes.put("application/vnd.palm", ".pdb");
        mimeTypes.put("application/vnd.pawaafile", ".paw");
        mimeTypes.put("application/vnd.pg.format", ".str");
        mimeTypes.put("application/vnd.pg.osasli", ".ei6");
        mimeTypes.put("application/vnd.picsel", ".efif");
        mimeTypes.put("application/vnd.pmi.widget", ".wg");
        mimeTypes.put("application/vnd.pocketlearn", ".plf");
        mimeTypes.put("application/vnd.powerbuilder6", ".pbd");
        mimeTypes.put("application/vnd.previewsystems.box", ".box");
        mimeTypes.put("application/vnd.proteus.magazine", ".mgz");
        mimeTypes.put("application/vnd.publishare-delta-tree", ".qps");
        mimeTypes.put("application/vnd.pvi.ptid1", ".ptid");
        mimeTypes.put("application/vnd.quark.quarkxpress", ".qxd");
        mimeTypes.put("application/vnd.realvnc.bed", ".bed");
        mimeTypes.put("application/vnd.recordare.musicxml", ".mxl");
        mimeTypes.put("application/vnd.recordare.musicxml+xml", ".musicxml");
        mimeTypes.put("application/vnd.rig.cryptonote", ".cryptonote");
        mimeTypes.put("application/vnd.rim.cod", ".cod");
        mimeTypes.put("application/vnd.rn-realmedia", ".rm");
        mimeTypes.put("application/vnd.route66.link66+xml", ".link66");
        mimeTypes.put("application/vnd.sailingtracker.track", ".st");
        mimeTypes.put("application/vnd.seemail", ".see");
        mimeTypes.put("application/vnd.sema", ".sema");
        mimeTypes.put("application/vnd.semd", ".semd");
        mimeTypes.put("application/vnd.semf", ".semf");
        mimeTypes.put("application/vnd.shana.informed.formdata", ".ifm");
        mimeTypes.put("application/vnd.shana.informed.formtemplate", ".itp");
        mimeTypes.put("application/vnd.shana.informed.interchange", ".iif");
        mimeTypes.put("application/vnd.shana.informed.package", ".ipk");
        mimeTypes.put("application/vnd.simtech-mindmapper", ".twd");
        mimeTypes.put("application/vnd.smaf", ".mmf");
        mimeTypes.put("application/vnd.smart.teacher", ".teacher");
        mimeTypes.put("application/vnd.solent.sdkm+xml", ".sdkm");
        mimeTypes.put("application/vnd.spotfire.dxp", ".dxp");
        mimeTypes.put("application/vnd.spotfire.sfs", ".sfs");
        mimeTypes.put("application/vnd.stardivision.calc", ".sdc");
        mimeTypes.put("application/vnd.stardivision.draw", ".sda");
        mimeTypes.put("application/vnd.stardivision.impress", ".sdd");
        mimeTypes.put("application/vnd.stardivision.math", ".smf");
        mimeTypes.put("application/vnd.stardivision.writer", ".sdw");
        mimeTypes.put("application/vnd.stardivision.writer-global", ".sgl");
        mimeTypes.put("application/vnd.stepmania.stepchart", ".sm");
        mimeTypes.put("application/vnd.sun.xml.calc", ".sxc");
        mimeTypes.put("application/vnd.sun.xml.calc.template", ".stc");
        mimeTypes.put("application/vnd.sun.xml.draw", ".sxd");
        mimeTypes.put("application/vnd.sun.xml.draw.template", ".std");
        mimeTypes.put("application/vnd.sun.xml.impress", ".sxi");
        mimeTypes.put("application/vnd.sun.xml.impress.template", ".sti");
        mimeTypes.put("application/vnd.sun.xml.math", ".sxm");
        mimeTypes.put("application/vnd.sun.xml.writer", ".sxw");
        mimeTypes.put("application/vnd.sun.xml.writer.global", ".sxg");
        mimeTypes.put("application/vnd.sun.xml.writer.template", ".stw");
        mimeTypes.put("application/vnd.sus-calendar", ".sus");
        mimeTypes.put("application/vnd.svd", ".svd");
        mimeTypes.put("application/vnd.symbian.install", ".sis");
        mimeTypes.put("application/vnd.syncml+xml", ".xsm");
        mimeTypes.put("application/vnd.syncml.dm+wbxml", ".bdm");
        mimeTypes.put("application/vnd.syncml.dm+xml", ".xdm");
        mimeTypes.put("application/vnd.tao.intent-module-archive", ".tao");
        mimeTypes.put("application/vnd.tmobile-livetv", ".tmo");
        mimeTypes.put("application/vnd.trid.tpt", ".tpt");
        mimeTypes.put("application/vnd.triscape.mxs", ".mxs");
        mimeTypes.put("application/vnd.trueapp", ".tra");
        mimeTypes.put("application/vnd.ufdl", ".ufd");
        mimeTypes.put("application/vnd.uiq.theme", ".utz");
        mimeTypes.put("application/vnd.umajin", ".umj");
        mimeTypes.put("application/vnd.unity", ".unityweb");
        mimeTypes.put("application/vnd.uoml+xml", ".uoml");
        mimeTypes.put("application/vnd.vcx", ".vcx");
        mimeTypes.put("application/vnd.visio", ".vsd");
        mimeTypes.put("application/vnd.visionary", ".vis");
        mimeTypes.put("application/vnd.vsf", ".vsf");
        mimeTypes.put("application/vnd.wap.wbxml", ".wbxml");
        mimeTypes.put("application/vnd.wap.wmlc", ".wmlc");
        mimeTypes.put("application/vnd.wap.wmlscriptc", ".wmlsc");
        mimeTypes.put("application/vnd.webturbo", ".wtb");
        mimeTypes.put("application/vnd.wolfram.player", ".nbp");
        mimeTypes.put("application/vnd.wordperfect", ".wpd");
        mimeTypes.put("application/vnd.wqd", ".wqd");
        mimeTypes.put("application/vnd.wt.stf", ".stf");
        mimeTypes.put("application/vnd.xara", ".xar");
        mimeTypes.put("application/vnd.xfdl", ".xfdl");
        mimeTypes.put("application/vnd.yamaha.hv-dic", ".hvd");
        mimeTypes.put("application/vnd.yamaha.hv-script", ".hvs");
        mimeTypes.put("application/vnd.yamaha.hv-voice", ".hvp");
        mimeTypes.put("application/vnd.yamaha.openscoreformat", ".osf");
        mimeTypes.put("application/vnd.yamaha.openscoreformat.osfpvg+xml", ".osfpvg");
        mimeTypes.put("application/vnd.yamaha.smaf-audio", ".saf");
        mimeTypes.put("application/vnd.yamaha.smaf-phrase", ".spf");
        mimeTypes.put("application/vnd.yellowriver-custom-menu", ".cmp");
        mimeTypes.put("application/vnd.zul", ".zir");
        mimeTypes.put("application/vnd.zzazz.deck+xml", ".zaz");
        mimeTypes.put("application/voicexml+xml", ".vxml");
        mimeTypes.put("application/widget", ".wgt");
        mimeTypes.put("application/winhlp", ".hlp");
        mimeTypes.put("application/wsdl+xml", ".wsdl");
        mimeTypes.put("application/wspolicy+xml", ".wspolicy");
        mimeTypes.put("application/x-7z-compressed", ".7z");
        mimeTypes.put("application/x-abiword", ".abw");
        mimeTypes.put("application/x-ace-compressed", ".ace");
        mimeTypes.put("application/x-authorware-bin", ".aab");
        mimeTypes.put("application/x-authorware-map", ".aam");
        mimeTypes.put("application/x-authorware-seg", ".aas");
        mimeTypes.put("application/x-bcpio", ".bcpio");
        mimeTypes.put("application/x-bittorrent", ".torrent");
        mimeTypes.put("application/x-bzip", ".bz");
        mimeTypes.put("application/x-bzip2", ".bz2");
        mimeTypes.put("application/x-cdlink", ".vcd");
        mimeTypes.put("application/x-chat", ".chat");
        mimeTypes.put("application/x-chess-pgn", ".pgn");
        mimeTypes.put("application/x-cpio", ".cpio");
        mimeTypes.put("application/x-csh", ".csh");
        mimeTypes.put("application/x-debian-package", ".deb");
        mimeTypes.put("application/x-director", ".dir");
        mimeTypes.put("application/x-doom", ".wad");
        mimeTypes.put("application/x-dtbncx+xml", ".ncx");
        mimeTypes.put("application/x-dtbook+xml", ".dtb");
        mimeTypes.put("application/x-dtbresource+xml", ".res");
        mimeTypes.put("application/x-dvi", ".dvi");
        mimeTypes.put("application/x-font-bdf", ".bdf");
        mimeTypes.put("application/x-font-ghostscript", ".gsf");
        mimeTypes.put("application/x-font-linux-psf", ".psf");
        mimeTypes.put("application/x-font-otf", ".otf");
        mimeTypes.put("application/x-font-pcf", ".pcf");
        mimeTypes.put("application/x-font-snf", ".snf");
        mimeTypes.put("application/x-font-ttf", ".ttf");
        mimeTypes.put("application/x-font-type1", ".pfa");
        mimeTypes.put("application/x-font-woff", ".woff");
        mimeTypes.put("application/x-futuresplash", ".spl");
        mimeTypes.put("application/x-gnumeric", ".gnumeric");
        mimeTypes.put("application/x-gtar", ".gtar");
        mimeTypes.put("application/x-hdf", ".hdf");
        mimeTypes.put("application/x-java-jnlp-file", ".jnlp");
        mimeTypes.put("application/x-latex", ".latex");
        mimeTypes.put("application/x-mobipocket-ebook", ".prc");
        mimeTypes.put("application/x-ms-application", ".application");
        mimeTypes.put("application/x-ms-wmd", ".wmd");
        mimeTypes.put("application/x-ms-wmz", ".wmz");
        mimeTypes.put("application/x-ms-xbap", ".xbap");
        mimeTypes.put("application/x-msaccess", ".mdb");
        mimeTypes.put("application/x-msbinder", ".obd");
        mimeTypes.put("application/x-mscardfile", ".crd");
        mimeTypes.put("application/x-msclip", ".clp");
        mimeTypes.put("application/x-msdownload", ".exe");
        mimeTypes.put("application/x-msmediaview", ".mvb");
        mimeTypes.put("application/x-msmetafile", ".wmf");
        mimeTypes.put("application/x-msmoney", ".mny");
        mimeTypes.put("application/x-mspublisher", ".pub");
        mimeTypes.put("application/x-msschedule", ".scd");
        mimeTypes.put("application/x-msterminal", ".trm");
        mimeTypes.put("application/x-mswrite", ".wri");
        mimeTypes.put("application/x-netcdf", ".nc");
        mimeTypes.put("application/x-pkcs12", ".p12");
        mimeTypes.put("application/x-pkcs7-certificates", ".p7b");
        mimeTypes.put("application/x-pkcs7-certreqresp", ".p7r");
        mimeTypes.put("application/x-rar-compressed", ".rar");
        mimeTypes.put("application/x-sh", ".sh");
        mimeTypes.put("application/x-shar", ".shar");
        mimeTypes.put("application/x-shockwave-flash", ".swf");
        mimeTypes.put("application/x-silverlight-app", ".xap");
        mimeTypes.put("application/x-stuffit", ".sit");
        mimeTypes.put("application/x-stuffitx", ".sitx");
        mimeTypes.put("application/x-sv4cpio", ".sv4cpio");
        mimeTypes.put("application/x-sv4crc", ".sv4crc");
        mimeTypes.put("application/x-tar", ".tar");
        mimeTypes.put("application/x-tcl", ".tcl");
        mimeTypes.put("application/x-tex", ".tex");
        mimeTypes.put("application/x-tex-tfm", ".tfm");
        mimeTypes.put("application/x-texinfo", ".texinfo");
        mimeTypes.put("application/x-ustar", ".ustar");
        mimeTypes.put("application/x-wais-source", ".src");
        mimeTypes.put("application/x-x509-ca-cert", ".der");
        mimeTypes.put("application/x-xfig", ".fig");
        mimeTypes.put("application/x-xpinstall", ".xpi");
        mimeTypes.put("application/xcap-diff+xml", ".xdf");
        mimeTypes.put("application/xenc+xml", ".xenc");
        mimeTypes.put("application/xhtml+xml", ".xhtml");
        mimeTypes.put("application/xml", ".xml");
        mimeTypes.put("application/xml-dtd", ".dtd");
        mimeTypes.put("application/xop+xml", ".xop");
        mimeTypes.put("application/xslt+xml", ".xslt");
        mimeTypes.put("application/xspf+xml", ".xspf");
        mimeTypes.put("application/xv+xml", ".mxml");
        mimeTypes.put("application/yang", ".yang");
        mimeTypes.put("application/yin+xml", ".yin");
        mimeTypes.put("application/zip", ".zip");
        mimeTypes.put("audio/adpcm", ".adp");
        mimeTypes.put("audio/basic", ".au");
        mimeTypes.put("audio/midi", ".mid");
        mimeTypes.put("audio/mp4", ".mp4a");
        mimeTypes.put("audio/mpeg", ".mpga");
        mimeTypes.put("audio/ogg", ".oga");
        mimeTypes.put("audio/vnd.dece.audio", ".uva");
        mimeTypes.put("audio/vnd.digital-winds", ".eol");
        mimeTypes.put("audio/vnd.dra", ".dra");
        mimeTypes.put("audio/vnd.dts", ".dts");
        mimeTypes.put("audio/vnd.dts.hd", ".dtshd");
        mimeTypes.put("audio/vnd.lucent.voice", ".lvp");
        mimeTypes.put("audio/vnd.ms-playready.media.pya", ".pya");
        mimeTypes.put("audio/vnd.nuera.ecelp4800", ".ecelp4800");
        mimeTypes.put("audio/vnd.nuera.ecelp7470", ".ecelp7470");
        mimeTypes.put("audio/vnd.nuera.ecelp9600", ".ecelp9600");
        mimeTypes.put("audio/vnd.rip", ".rip");
        mimeTypes.put("audio/webm", ".weba");
        mimeTypes.put("audio/x-aac", ".aac");
        mimeTypes.put("audio/x-aiff", ".aif");
        mimeTypes.put("audio/x-mpegurl", ".m3u");
        mimeTypes.put("audio/x-ms-wax", ".wax");
        mimeTypes.put("audio/x-ms-wma", ".wma");
        mimeTypes.put("audio/x-pn-realaudio", ".ram");
        mimeTypes.put("audio/x-pn-realaudio-plugin", ".rmp");
        mimeTypes.put("audio/x-wav", ".wav");
        mimeTypes.put("chemical/x-cdx", ".cdx");
        mimeTypes.put("chemical/x-cif", ".cif");
        mimeTypes.put("chemical/x-cmdf", ".cmdf");
        mimeTypes.put("chemical/x-cml", ".cml");
        mimeTypes.put("chemical/x-csml", ".csml");
        mimeTypes.put("chemical/x-xyz", ".xyz");
        mimeTypes.put("image/bmp", ".bmp");
        mimeTypes.put("image/cgm", ".cgm");
        mimeTypes.put("image/g3fax", ".g3");
        mimeTypes.put("image/gif", ".gif");
        mimeTypes.put("image/ief", ".ief");
        mimeTypes.put("image/jpeg", ".jpeg, .jpg");
        mimeTypes.put("image/ktx", ".ktx");
        mimeTypes.put("image/png", ".png");
        mimeTypes.put("image/prs.btif", ".btif");
        mimeTypes.put("image/svg+xml", ".svg");
        mimeTypes.put("image/tiff", ".tiff");
        mimeTypes.put("image/vnd.adobe.photoshop", ".psd");
        mimeTypes.put("image/vnd.dece.graphic", ".uvi");
        mimeTypes.put("image/vnd.djvu", ".djvu");
        mimeTypes.put("image/vnd.dvb.subtitle", ".sub");
        mimeTypes.put("image/vnd.dwg", ".dwg");
        mimeTypes.put("image/vnd.dxf", ".dxf");
        mimeTypes.put("image/vnd.fastbidsheet", ".fbs");
        mimeTypes.put("image/vnd.fpx", ".fpx");
        mimeTypes.put("image/vnd.fst", ".fst");
        mimeTypes.put("image/vnd.fujixerox.edmics-mmr", ".mmr");
        mimeTypes.put("image/vnd.fujixerox.edmics-rlc", ".rlc");
        mimeTypes.put("image/vnd.ms-modi", ".mdi");
        mimeTypes.put("image/vnd.net-fpx", ".npx");
        mimeTypes.put("image/vnd.wap.wbmp", ".wbmp");
        mimeTypes.put("image/vnd.xiff", ".xif");
        mimeTypes.put("image/webp", ".webp");
        mimeTypes.put("image/x-cmu-raster", ".ras");
        mimeTypes.put("image/x-cmx", ".cmx");
        mimeTypes.put("image/x-freehand", ".fh");
        mimeTypes.put("image/x-icon", ".ico");
        mimeTypes.put("image/x-pcx", ".pcx");
        mimeTypes.put("image/x-pict", ".pic");
        mimeTypes.put("image/x-portable-anymap", ".pnm");
        mimeTypes.put("image/x-portable-bitmap", ".pbm");
        mimeTypes.put("image/x-portable-graymap", ".pgm");
        mimeTypes.put("image/x-portable-pixmap", ".ppm");
        mimeTypes.put("image/x-rgb", ".rgb");
        mimeTypes.put("image/x-xbitmap", ".xbm");
        mimeTypes.put("image/x-xpixmap", ".xpm");
        mimeTypes.put("image/x-xwindowdump", ".xwd");
        mimeTypes.put("message/rfc822", ".eml");
        mimeTypes.put("model/iges", ".igs");
        mimeTypes.put("model/mesh", ".msh");
        mimeTypes.put("model/vnd.collada+xml", ".dae");
        mimeTypes.put("model/vnd.dwf", ".dwf");
        mimeTypes.put("model/vnd.gdl", ".gdl");
        mimeTypes.put("model/vnd.gtw", ".gtw");
        mimeTypes.put("model/vnd.mts", ".mts");
        mimeTypes.put("model/vnd.vtu", ".vtu");
        mimeTypes.put("model/vrml", ".wrl");
        mimeTypes.put("text/calendar", ".ics");
        mimeTypes.put("text/css", ".css");
        mimeTypes.put("text/csv", ".csv");
        mimeTypes.put("text/html", ".html");
        mimeTypes.put("text/n3", ".n3");
        mimeTypes.put("text/plain", ".txt");
        mimeTypes.put("text/plain-bas", ".par");
        mimeTypes.put("text/prs.lines.tag", ".dsc");
        mimeTypes.put("text/richtext", ".rtx");
        mimeTypes.put("text/sgml", ".sgml");
        mimeTypes.put("text/tab-separated-values", ".tsv");
        mimeTypes.put("text/troff", ".t");
        mimeTypes.put("text/turtle", ".ttl");
        mimeTypes.put("text/uri-list", ".uri");
        mimeTypes.put("text/vnd.curl", ".curl");
        mimeTypes.put("text/vnd.curl.dcurl", ".dcurl");
        mimeTypes.put("text/vnd.curl.mcurl", ".mcurl");
        mimeTypes.put("text/vnd.curl.scurl", ".scurl");
        mimeTypes.put("text/vnd.fly", ".fly");
        mimeTypes.put("text/vnd.fmi.flexstor", ".flx");
        mimeTypes.put("text/vnd.graphviz", ".gv");
        mimeTypes.put("text/vnd.in3d.3dml", ".3dml");
        mimeTypes.put("text/vnd.in3d.spot", ".spot");
        mimeTypes.put("text/vnd.sun.j2me.app-descriptor", ".jad");
        mimeTypes.put("text/vnd.wap.wml", ".wml");
        mimeTypes.put("text/vnd.wap.wmlscript", ".wmls");
        mimeTypes.put("text/x-asm", ".s");
        mimeTypes.put("text/x-c", ".c");
        mimeTypes.put("text/x-fortran", ".f");
        mimeTypes.put("text/x-java-source,java", ".java");
        mimeTypes.put("text/x-pascal", ".p");
        mimeTypes.put("text/x-setext", ".etx");
        mimeTypes.put("text/x-uuencode", ".uu");
        mimeTypes.put("text/x-vcalendar", ".vcs");
        mimeTypes.put("text/x-vcard", ".vcf");
        mimeTypes.put("text/yaml", ".yaml");
        mimeTypes.put("video/3gpp", ".3gp");
        mimeTypes.put("video/3gpp2", ".3g2");
        mimeTypes.put("video/h261", ".h261");
        mimeTypes.put("video/h263", ".h263");
        mimeTypes.put("video/h264", ".h264");
        mimeTypes.put("video/jpeg", ".jpgv");
        mimeTypes.put("video/jpm", ".jpm");
        mimeTypes.put("video/mj2", ".mj2");
        mimeTypes.put("video/mp4", ".mp4");
        mimeTypes.put("video/mpeg", ".mpeg");
        mimeTypes.put("video/ogg", ".ogv");
        mimeTypes.put("video/quicktime", ".qt");
        mimeTypes.put("video/vnd.dece.hd", ".uvh");
        mimeTypes.put("video/vnd.dece.mobile", ".uvm");
        mimeTypes.put("video/vnd.dece.pd", ".uvp");
        mimeTypes.put("video/vnd.dece.sd", ".uvs");
        mimeTypes.put("video/vnd.dece.video", ".uvv");
        mimeTypes.put("video/vnd.fvt", ".fvt");
        mimeTypes.put("video/vnd.mpegurl", ".mxu");
        mimeTypes.put("video/vnd.ms-playready.media.pyv", ".pyv");
        mimeTypes.put("video/vnd.uvvu.mp4", ".uvu");
        mimeTypes.put("video/vnd.vivo", ".viv");
        mimeTypes.put("video/webm", ".webm");
        mimeTypes.put("video/x-f4v", ".f4v");
        mimeTypes.put("video/x-fli", ".fli");
        mimeTypes.put("video/x-flv", ".flv");
        mimeTypes.put("video/x-m4v", ".m4v");
        mimeTypes.put("video/x-ms-asf", ".asf");
        mimeTypes.put("video/x-ms-wm", ".wm");
        mimeTypes.put("video/x-ms-wmv", ".wmv");
        mimeTypes.put("video/x-ms-wmx", ".wmx");
        mimeTypes.put("video/x-ms-wvx", ".wvx");
        mimeTypes.put("video/x-msvideo", ".avi");
        mimeTypes.put("video/x-sgi-movie", ".movie");
        mimeTypes.put("x-conference/x-cooltalk", ".ice");
        return mimeTypes;
    }

    private static Set<String> getTextMimeTypes() {
        HashSet<String> mimeTypes = new HashSet<String>();
        mimeTypes.add("application/javascript");
        mimeTypes.add("application/json");
        mimeTypes.add("application/xml");
        mimeTypes.add("text/calendar");
        mimeTypes.add("text/css");
        mimeTypes.add("text/csv");
        mimeTypes.add("text/html");
        mimeTypes.add("text/n3");
        mimeTypes.add("text/plain");
        mimeTypes.add("text/plain-bas");
        mimeTypes.add("text/prs.lines.tag");
        mimeTypes.add("text/richtext");
        mimeTypes.add("text/sgml");
        mimeTypes.add("text/tab-separated-values");
        mimeTypes.add("text/troff");
        mimeTypes.add("text/turtle");
        mimeTypes.add("text/uri-list");
        mimeTypes.add("text/vnd.curl");
        mimeTypes.add("text/vnd.curl.dcurl");
        mimeTypes.add("text/vnd.curl.mcurl");
        mimeTypes.add("text/vnd.curl.scurl");
        mimeTypes.add("text/vnd.fly");
        mimeTypes.add("text/vnd.fmi.flexstor");
        mimeTypes.add("text/vnd.graphviz");
        mimeTypes.add("text/vnd.in3d.3dml");
        mimeTypes.add("text/vnd.in3d.spot");
        mimeTypes.add("text/vnd.sun.j2me.app-descriptor");
        mimeTypes.add("text/vnd.wap.wml");
        mimeTypes.add("text/vnd.wap.wmlscript");
        mimeTypes.add("text/x-asm");
        mimeTypes.add("text/x-c");
        mimeTypes.add("text/x-fortran");
        mimeTypes.add("text/x-java-source,java");
        mimeTypes.add("text/x-pascal");
        mimeTypes.add("text/x-setext");
        mimeTypes.add("text/x-uuencode");
        mimeTypes.add("text/x-vcalendar");
        mimeTypes.add("text/x-vcard");
        mimeTypes.add("text/yaml");
        return mimeTypes;
    }

    public static String getFileExtention(String mimeType) {
        if (mimeType != null) {
            return MIME_TYPES.get(mimeType);
        }
        return null;
    }

    public static boolean isTextType(String mimeType) {
        if (mimeType != null) {
            return TEXT_MIME_TYPES.contains(mimeType);
        }
        return false;
    }
}

