/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.data.json;

import org.apache.commons.codec.binary.Base64;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class JWTHelper {
    private final String type;
    private final JSONObject header;
    private final JSONObject payload;

    public JWTHelper(String token) {
        AssertUtils.notEmpty(token, "Token");
        String[] parts = token.split("\\.", 4);
        AssertUtils.checkArgument(parts.length == 3, "Invalid token format");
        String headerPart = this.decodeBase64(parts[0]);
        String payloadPart = this.decodeBase64(parts[1]);
        AssertUtils.notEmpty(headerPart, "Token header");
        AssertUtils.notEmpty(payloadPart, "Token payload");
        this.header = new JSONObject(headerPart);
        this.type = this.header.optString("typ", null);
        this.payload = StringUtils.equalsIgnoreCase(this.type, "JWT") ? new JSONObject(payloadPart) : null;
    }

    public String getType() {
        return this.type;
    }

    public JSONObject getHeader() {
        return this.header;
    }

    public JSONObject getPayload() {
        return this.payload;
    }

    public String getClaimAsString(String name) {
        return this.payload.optString(name, null);
    }

    public Integer getClaimAsInteger(String name) {
        try {
            return this.payload.getInt(name);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public Double getClaimAsDouble(String name) {
        try {
            return this.payload.getDouble(name);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public String toString() {
        return String.format("%s.%s", this.header, this.payload);
    }

    private String decodeBase64(String data) {
        String result = null;
        if (StringUtils.notEmpty(data)) {
            Base64 decoder = new Base64(true);
            byte[] bytes = decoder.decode(data);
            result = StringUtils.create(bytes);
        }
        return result;
    }
}

