/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.data.json;

import org.bacza.utils.AssertUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public final class JSONUtils {
    public static JSONObject createObject() {
        return new JSONObject();
    }

    public static JSONArray createArray() {
        return new JSONArray();
    }

    public static JSONObject getObject(JSONObject object, String key) {
        AssertUtils.notNull(object, "object");
        AssertUtils.notEmpty(key, "key");
        JSONObject value = object.optJSONObject(key);
        if (value == null) {
            value = JSONUtils.createObject();
            object.put(key, (Object)value);
        }
        return value;
    }

    public static JSONObject createObject(JSONObject object, String key) {
        AssertUtils.notNull(object, "object");
        AssertUtils.notEmpty(key, "key");
        JSONObject obj = JSONUtils.createObject();
        object.put(key, (Object)obj);
        return obj;
    }

    public static JSONObject createObject(JSONArray array) {
        AssertUtils.notNull(array, "array");
        JSONObject obj = JSONUtils.createObject();
        array.put((Object)obj);
        return obj;
    }

    public static JSONArray createArray(JSONObject object, String key) {
        AssertUtils.notNull(object, "object");
        AssertUtils.notEmpty(key, "key");
        JSONArray arr = JSONUtils.createArray();
        object.put(key, (Object)arr);
        return arr;
    }
}

