/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.data.html;

import java.util.LinkedList;
import java.util.List;
import org.bacza.data.html.ElementUtils;
import org.bacza.data.html.FormElement;
import org.bacza.data.html.FormValueOption;
import org.bacza.data.html.Tag;
import org.bacza.utils.StringUtils;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class SelectTag
extends Tag
implements FormElement {
    private List<FormValueOption> options = new LinkedList<FormValueOption>();

    public SelectTag() {
    }

    public SelectTag(Element element) {
        super(element);
        this.initializeOptions(element);
    }

    private void initializeOptions(Element select) {
        if (select != null) {
            Elements elements = select.getElementsByTag("option");
            for (Element element : elements) {
                FormValueOption option = new FormValueOption(element.text(), element.attr("value"));
                option.setSelected(ElementUtils.hasAttrEqualAny(element, "selected", "selected", ""));
                this.options.add(option);
            }
        }
    }

    @Override
    public String getName() {
        return this.getAttrName();
    }

    @Override
    public String getType() {
        return "select";
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean isMultiSelectable() {
        return this.isMultiple();
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public List<FormValueOption> getOptions() {
        return this.options;
    }

    public String getAttrName() {
        return this.getAttribute("name");
    }

    public void setAttrName(String name) {
        this.setAttribute("name", name);
    }

    public boolean isMultiple() {
        return StringUtils.equalsAnyIgnoreCase(this.getAttribute("multiple"), "multiple", "");
    }

    public void setMultiple(boolean multiple) {
        this.setAttribute("multiple", multiple ? "multiple" : null);
    }

    @Override
    public String toString() {
        return String.format("select: name=%s, options=%d (%s)", this.getAttrName(), this.options.size(), this.isMultiSelectable() ? "multiple" : "single");
    }
}

