/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.data.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bacza.data.html.FormElement;
import org.bacza.data.html.FormValue;
import org.bacza.data.html.FormValueOption;
import org.bacza.data.html.InputTag;
import org.bacza.data.html.SelectTag;
import org.bacza.data.html.TextareaTag;
import org.bacza.utils.StringPair;
import org.bacza.utils.StringUtils;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class FormData {
    private String id;
    private String name;
    private String action;
    private String method;
    private List<FormElement> elements = new ArrayList<FormElement>(64);
    private List<FormValue> values = new ArrayList<FormValue>(64);
    private Map<String, FormValue> valuesByName = new HashMap<String, FormValue>();

    public FormData() {
    }

    public FormData(Element root) {
        this();
        this.initialize(root);
    }

    private void initialize(Element root) {
        if (root != null) {
            this.setId(root.attr("id"));
            this.setName(root.attr("name"));
            this.setAction(root.attr("action"));
            this.setMethod(StringUtils.toLowerCase(root.attr("method")));
            Elements elements = root.select("input, select, textarea, button");
            for (Element element : elements) {
                String tag = StringUtils.toLowerCase(element.nodeName());
                if ("input".equals(tag)) {
                    this.addElement(new InputTag(element));
                    continue;
                }
                if ("select".equals(tag)) {
                    this.addElement(new SelectTag(element));
                    continue;
                }
                if (!"textarea".equals(tag)) continue;
                this.addElement(new TextareaTag(element));
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean addElement(FormElement element) {
        String name;
        if (element != null && StringUtils.notEmpty(name = element.getName())) {
            FormValue value = this.valuesByName.get(name);
            if (value == null) {
                value = new FormValue();
                if (value.addElement(element)) {
                    this.values.add(value);
                    this.valuesByName.put(name, value);
                    this.elements.add(element);
                    return true;
                }
            } else if (value.addElement(element)) {
                this.elements.add(element);
                return true;
            }
        }
        return false;
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public FormElement getElement(int index) {
        return this.elements.get(index);
    }

    public List<FormElement> getElements() {
        return this.elements;
    }

    public int getValueCount() {
        return this.values.size();
    }

    public FormValue getValue(int index) {
        return this.values.get(index);
    }

    public FormValue getValue(String name) {
        return this.valuesByName.get(name);
    }

    public List<FormValue> getValues() {
        return this.values;
    }

    public boolean removeValue(String name) {
        FormValue value = this.valuesByName.get(name);
        if (value != null) {
            this.valuesByName.remove(name);
            this.values.remove(value);
            return true;
        }
        return false;
    }

    public boolean containsValue(String name) {
        return this.valuesByName.containsKey(name);
    }

    public boolean containsValueType(String type) {
        if (type != null) {
            for (FormValue value : this.values) {
                if (!type.equals(value.getType())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsAllValues(Collection<String> names) {
        if (names != null) {
            for (String name : names) {
                if (this.valuesByName.containsKey(name)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean containsAnyValue(Collection<String> names) {
        if (names != null) {
            for (String name : names) {
                if (!this.valuesByName.containsKey(name)) continue;
                return true;
            }
        }
        return false;
    }

    public List<StringPair> getFormData() {
        LinkedList<StringPair> result = new LinkedList<StringPair>();
        for (FormValue value : this.values) {
            if (value.isSelectable()) {
                List<FormValueOption> options = value.getOptions();
                if (options == null) continue;
                for (FormValueOption option : options) {
                    if (!option.isSelected()) continue;
                    result.add(new StringPair(value.getName(), StringUtils.nvl(option.getValue(), value.getDefaultSelectedOptionValue())));
                }
                continue;
            }
            result.add(new StringPair(value.getName(), value.getValue()));
        }
        return result;
    }

    public String getFormDataAsString() {
        String separator = "\n";
        StringBuilder sb = new StringBuilder(65536);
        for (StringPair entry : this.getFormData()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append((String)entry.getKey());
            sb.append(":");
            sb.append((String)entry.getValue());
        }
        return sb.toString();
    }
}

