/*
 * Decompiled with CFR 0.152.
 */
package geocentral.ui.views;

import geocentral.common.data.DataModel;
import geocentral.ui.views.IViewChangeListener;
import geocentral.ui.views.ViewActionArgs;
import geocentral.ui.views.ViewChangeListenerList;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Control;

public abstract class View {
    private final ViewChangeListenerList viewChangeListeners = new ViewChangeListenerList();

    public abstract DataModel<?> getDataModel();

    public abstract Control createControl(CTabItem var1);

    public void setFocus() {
    }

    public void activated() {
    }

    public void deactivated() {
    }

    public void closed() {
    }

    public MenuManager getMenuManager() {
        return null;
    }

    public void addStatusLineContributions(StatusLineManager manager) {
    }

    public void onAction(ViewActionArgs args) {
    }

    public void onCut() {
    }

    public void onCopy() {
    }

    public void onPaste() {
    }

    public void onDelete() {
    }

    protected void notifyFilenameChange(String filename) {
        for (IViewChangeListener l : this.viewChangeListeners.getListeners()) {
            l.filenameChanged(filename);
        }
    }

    protected void notifyDirtyStateChange(boolean dirtyState) {
        for (IViewChangeListener l : this.viewChangeListeners.getListeners()) {
            l.dirtyStateChanged(dirtyState);
        }
    }
}

