/*
 * Decompiled with CFR 0.152.
 */
package geocentral.http;

import geocentral.common.app.UserProfile;
import geocentral.common.app.UserProfileService;
import geocentral.common.ui.preferences.PreferenceStoreManager;
import geocentral.http.ProxyAuthenticator;
import geocentral.http.WebClientInterceptor;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.http.FileCookieJar;
import org.bacza.http.WebClient;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.DateUtils;
import org.bacza.utils.IOUtils;
import org.bacza.utils.StringUtils;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class WebClientManager
implements IPropertyChangeListener {
    private static final Log log = LogFactory.getLog(WebClientManager.class);
    private static final WebClientManager instance = new WebClientManager();
    private static final OkHttpClient masterClient = WebClientManager.createMasterClient();
    private static final Set<String> properties = WebClientManager.createNetworkProperties();
    private Map<UserProfile, WebClientHelper> userClientHelpers = new HashMap<UserProfile, WebClientHelper>();
    private WebClientHelper systemClientHelper = null;

    public static WebClientManager getInstance() {
        return instance;
    }

    private WebClientManager() {
        PreferenceStoreManager.getStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public synchronized void propertyChange(PropertyChangeEvent event) {
        WebClientHelper helper;
        UserProfile profile;
        String property = event.getProperty();
        if (StringUtils.notEmpty(property) && properties.contains(property) && (profile = UserProfileService.getInstance().getCurrentProfile()) != null && (helper = this.userClientHelpers.get(profile)) != null) {
            helper.invalid = true;
            this.systemClientHelper = null;
        }
    }

    private FileCookieJar createCookieStore(UserProfile profile) {
        FileCookieJar cookieStore = new FileCookieJar(profile);
        Cookie.Builder c = new Cookie.Builder();
        c.name("LogPageOptOut");
        c.value("true");
        c.domain("www.geocaching.com");
        c.path("/");
        c.expiresAt(DateUtils.parseDate("2024-03-15", "yyyy-MM-dd").getTime());
        cookieStore.addOverride(c.build());
        try {
            cookieStore.load();
        }
        catch (IOException e) {
            log.debug((Object)e.getMessage());
        }
        return cookieStore;
    }

    private static OkHttpClient createMasterClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.interceptors().clear();
        builder.networkInterceptors().clear();
        builder.addInterceptor((Interceptor)new WebClientInterceptor());
        builder.protocols(Arrays.asList(Protocol.HTTP_1_1));
        return builder.build();
    }

    private WebClient createWebClient(CookieJar cookieStore) {
        OkHttpClient.Builder builder = masterClient.newBuilder();
        if (cookieStore != null) {
            builder.cookieJar(cookieStore);
        }
        int connectTimeout = StringUtils.parseInt(PreferenceStoreManager.getStore().getString("geocentral.preferences.net.connect_timeout"), 30);
        int socketTimeout = StringUtils.parseInt(PreferenceStoreManager.getStore().getString("geocentral.preferences.net.socket_timeout"), 90);
        builder.connectTimeout((long)connectTimeout, TimeUnit.SECONDS);
        builder.readTimeout((long)socketTimeout, TimeUnit.SECONDS);
        builder.writeTimeout((long)socketTimeout, TimeUnit.SECONDS);
        builder.proxy(null);
        boolean useProxy = PreferenceStoreManager.getStore().getBoolean("geocentral.preferences.net.use_proxy");
        boolean useProxyAuth = PreferenceStoreManager.getStore().getBoolean("geocentral.preferences.net.use_proxy_auth");
        if (useProxy) {
            String proxyHost = PreferenceStoreManager.getStore().getString("geocentral.preferences.net.proxy_addr");
            String proxyPort = PreferenceStoreManager.getStore().getString("geocentral.preferences.net.proxy_port");
            try {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort)));
                builder.proxy(proxy);
                if (useProxyAuth) {
                    builder.proxyAuthenticator((Authenticator)new ProxyAuthenticator());
                }
            }
            catch (NumberFormatException nfe) {
                log.debug((Object)("Invalid HTTP proxy port: " + proxyPort));
            }
        }
        return new WebClient(builder.build());
    }

    public synchronized WebClient getClient(UserProfile profile) {
        WebClient webClient;
        FileCookieJar cookieStore;
        AssertUtils.notNull(profile, "UserProfile");
        WebClientHelper helper = this.userClientHelpers.get(profile);
        if (helper != null && helper.invalid) {
            cookieStore = helper.cookieStore;
            webClient = this.createWebClient(cookieStore);
            helper = new WebClientHelper(webClient, cookieStore);
            this.userClientHelpers.put(profile, helper);
        }
        if (helper == null) {
            cookieStore = this.createCookieStore(profile);
            webClient = this.createWebClient(cookieStore);
            helper = new WebClientHelper(webClient, cookieStore);
            this.userClientHelpers.put(profile, helper);
        }
        return helper.client;
    }

    public synchronized WebClient getSystemClient() {
        if (this.systemClientHelper == null) {
            this.systemClientHelper = new WebClientHelper(this.createWebClient(null), null);
        }
        return this.systemClientHelper.client;
    }

    public synchronized void shutdown() {
        PreferenceStoreManager.getStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.systemClientHelper != null) {
            this.systemClientHelper.close();
            this.systemClientHelper = null;
        }
        for (WebClientHelper meta : this.userClientHelpers.values()) {
            meta.close();
        }
        this.userClientHelpers.clear();
    }

    private static Set<String> createNetworkProperties() {
        HashSet<String> props = new HashSet<String>();
        props.add("geocentral.preferences.net.connect_timeout");
        props.add("geocentral.preferences.net.socket_timeout");
        props.add("geocentral.preferences.net.use_proxy");
        props.add("geocentral.preferences.net.use_proxy_auth");
        props.add("geocentral.preferences.net.proxy_addr");
        props.add("geocentral.preferences.net.proxy_port");
        props.add("geocentral.preferences.net.proxy_auth_user");
        props.add("geocentral.preferences.net.proxy_auth_pass");
        return props;
    }

    private class WebClientHelper {
        final WebClient client;
        final FileCookieJar cookieStore;
        boolean invalid;

        public WebClientHelper(WebClient client, FileCookieJar cookieStore) {
            this.client = client;
            this.cookieStore = cookieStore;
            this.invalid = false;
        }

        public void close() {
            IOUtils.close(this.cookieStore);
            this.client.getHttpClient().dispatcher().executorService().shutdown();
            this.client.getHttpClient().connectionPool().evictAll();
            IOUtils.close((Closeable)this.client.getHttpClient().cache());
        }
    }
}

