/*
 * Decompiled with CFR 0.152.
 */
package geocentral.files.gpx;

import geocentral.common.data.DataReaderContext;
import geocentral.common.data.IDataItem;
import geocentral.common.data.IDataStore;
import geocentral.common.data.parsers.IAttributes;
import geocentral.common.data.parsers.UserParser;
import geocentral.common.items.TrackItem;
import geocentral.common.items.TrackSegment;
import geocentral.common.items.WaypointItem;
import geocentral.files.gpx.WptParser;

public class TrksegParser
extends UserParser {
    private TrackItem track;
    private TrackSegment segment;
    private DataReaderContext trackReaderContext;

    public TrksegParser(DataReaderContext readerContext) {
        super(readerContext);
    }

    @Override
    public void startProcessing() {
        IDataItem item = this.readerContext.peekItem();
        if (!(item instanceof TrackItem)) {
            throw new IllegalStateException("No TrackItem on stack.");
        }
        this.track = (TrackItem)this.readerContext.peekItem();
        this.segment = new TrackSegment();
        this.trackReaderContext = new DataReaderContext(this.readerContext, new IDataStore(){

            @Override
            public void putItem(IDataItem item) {
                TrksegParser.this.segment.addWaypoint((WaypointItem)item);
            }

            @Override
            public void flush() {
            }
        });
    }

    @Override
    public void stopProcessing() {
        this.track.addTrackSegment(this.segment);
    }

    @Override
    public void startElement(String name, String namespace, String uri, IAttributes attrs) {
        if ("trkpt".equals(name)) {
            double lat = TrksegParser.getValueAsDouble(attrs.getAttributeValue("lat"), true);
            double lon = TrksegParser.getValueAsDouble(attrs.getAttributeValue("lon"), true);
            this.installParser(new WptParser(this.trackReaderContext, lat, lon));
        }
    }
}

