/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui.dialogs;

import geocentral.common.ui.dialogs.CharMetrics;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.MathUtils;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public final class WidgetSizeUtils {
    public static Point initialSize(Shell shell, int cols, int rows) {
        AssertUtils.notNull(shell, "Shell");
        GC gc = new GC((Drawable)shell);
        FontMetrics fm = gc.getFontMetrics();
        int width = fm.getAverageCharWidth();
        int height = fm.getHeight();
        gc.dispose();
        if (width > 0 && height > 0) {
            return new Point(width * cols, height * rows);
        }
        return CharMetrics.DEFAULT_CHAR_SIZE;
    }

    public static CharMetrics getCharMetrics(Shell shell) {
        Point charSize = WidgetSizeUtils.initialSize(shell, 1, 1);
        return new CharMetrics(charSize);
    }

    public static Point defaultSize(Control control) {
        if (control != null) {
            return control.computeSize(-1, -1);
        }
        return null;
    }

    public static Point extendSize(Point size, int x, int y) {
        if (size != null) {
            size.x += x;
            size.y += y;
        }
        return size;
    }

    public static Point maxSize(Point size1, Point size2) {
        if (size1 == null) {
            return size2;
        }
        if (size2 == null) {
            return size1;
        }
        int x = MathUtils.maxInt(size1.x, size2.x);
        int y = MathUtils.maxInt(size1.y, size2.y);
        return new Point(x, y);
    }

    public static Point getCenteredLocation(Control parent, Point size) {
        AssertUtils.notNull(parent, "Parent");
        AssertUtils.notNull(size, "Size");
        Rectangle rect = parent.getBounds();
        int x = rect.x + (rect.width - size.x) / 2;
        int y = rect.y + (rect.height - size.y) / 2;
        return new Point(x, y);
    }
}

