/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui.dialogs;

import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.plugins.AsyncContext;
import geocentral.common.ui.dialogs.ProgressDialog;
import geocentral.common.ws.LoginAction;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class SiteLoginDialog
extends ProgressDialog {
    private static final Log log = LogFactory.getLog(SiteLoginDialog.class);
    private boolean running = false;

    public SiteLoginDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        block12: {
            final LoginAction loginAction = this.getLoginAction();
            if (loginAction != null) {
                block11: {
                    block10: {
                        this.loginPrepare(loginAction);
                        try {
                            this.running = true;
                            this.run(true, true, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    loginAction.setAsyncContext(new AsyncContext(monitor));
                                    loginAction.execute();
                                }
                            });
                        }
                        catch (InvocationTargetException e) {
                            log.debug((Object)"Error", (Throwable)e);
                            this.running = false;
                            break block10;
                        }
                        catch (InterruptedException e) {
                            try {
                                log.debug((Object)"Error", (Throwable)e);
                                break block10;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                this.running = false;
                            }
                        }
                        this.running = false;
                    }
                    if (!loginAction.isLoginOk()) break block11;
                    this.loginSuccess();
                    super.okPressed();
                    break block12;
                }
                if (loginAction.isLoginCanceled()) {
                    this.loginCancelled();
                } else {
                    this.loginFailed();
                }
            }
        }
    }

    public boolean close() {
        if (this.running) {
            this.getProgressMonitor().setCanceled(true);
            return false;
        }
        return super.close();
    }

    public abstract GeocacheSite getSite();

    protected abstract LoginAction getLoginAction();

    protected abstract void loginPrepare(LoginAction var1);

    protected abstract void loginSuccess();

    protected abstract void loginFailed();

    protected abstract void loginCancelled();
}

