/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui.dialogs;

import geocentral.common.Messages;
import geocentral.common.app.SystemConfigService;
import geocentral.common.app.UserProfile;
import geocentral.common.app.UserProfileComparator;
import geocentral.common.app.UserProfileException;
import geocentral.common.app.UserProfileService;
import geocentral.common.ui.DialogUtils;
import geocentral.common.ui.ImageUtils;
import geocentral.common.ui.dialogs.CharMetrics;
import geocentral.common.ui.dialogs.CreateProfileDialog;
import geocentral.common.ui.dialogs.ProgressDialog;
import geocentral.common.ui.dialogs.WidgetSizeUtils;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;

public class SelectProfileDialog
extends ProgressDialog {
    private static final Image userImage = SWTResourceManager.getImage(SelectProfileDialog.class, "/images/misc/user-icon-64.jpg");
    private static final String PREF_LAST_PROFILE = "geocentral.dialog.select_profile.last_profile";
    private static final String PREF_AUTO_SELECT = "geocentral.dialog.select_profile.auto_select";
    private static boolean firstTime = true;
    private String lastProfileName = SystemConfigService.getInstance().getString("geocentral.dialog.select_profile.last_profile", null);
    private boolean autoSelect = SystemConfigService.getInstance().getBoolean("geocentral.dialog.select_profile.auto_select", false);
    private List<UserProfile> profiles;
    private UserProfile profile = UserProfileService.getInstance().getUserProfileByName(this.lastProfileName);
    private Table table;
    private Button btnSaveSelection;

    public SelectProfileDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.initProfiles();
    }

    public UserProfile getProfile() {
        return this.profile;
    }

    private void initProfiles() {
        this.profiles = UserProfileService.getInstance().getAllProfiles();
        this.profiles.sort(new UserProfileComparator());
    }

    @Override
    protected Control createPageControls(Composite parent) {
        CharMetrics cm = WidgetSizeUtils.getCharMetrics(this.getParentShell());
        this.setTitle(Messages.getString("SelectProfileDialog.title"));
        this.setMessage(Messages.getString("SelectProfileDialog.message"));
        Composite container = new Composite(parent, 0);
        GridLayout gl_container = new GridLayout(2, false);
        container.setLayout((Layout)gl_container);
        this.table = new Table(container, 68112);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(false);
        Button btnNewButton = new Button(container, 0);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProfileDialog.this.onCreateProfile();
            }
        });
        GridData gd_btnNewButton = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnNewButton.widthHint = cm.getWidth(15);
        btnNewButton.setLayoutData((Object)gd_btnNewButton);
        btnNewButton.setText(Messages.getString("SelectProfileDialog.new"));
        Button btnNewButton_2 = new Button(container, 0);
        btnNewButton_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProfileDialog.this.onDeleteProfile();
            }
        });
        btnNewButton_2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnNewButton_2.setText(Messages.getString("SelectProfileDialog.remove"));
        new Label(container, 0);
        this.btnSaveSelection = new Button(container, 32);
        this.btnSaveSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProfileDialog.this.autoSelect = SelectProfileDialog.this.btnSaveSelection.getSelection();
            }
        });
        this.btnSaveSelection.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnSaveSelection.setText(Messages.getString("SelectProfileDialog.remember"));
        this.btnSaveSelection.setSelection(this.autoSelect);
        new Label(container, 0);
        this.initControls();
        return container;
    }

    private void refreshTableData() {
        this.table.removeAll();
        for (UserProfile profile : this.profiles) {
            TableItem item = new TableItem(this.table, 0);
            item.setData((Object)profile);
        }
    }

    private void setTableSelection(UserProfile profile) {
        this.setTableSelection(this.profiles.indexOf(profile));
    }

    private void setTableSelection(int index) {
        this.table.setSelection(index < 0 ? 0 : index);
        this.profileSelectionChanged();
    }

    private void initControls() {
        final int imageWidth = SelectProfileDialog.userImage.getBounds().width;
        final int imageHeight = SelectProfileDialog.userImage.getBounds().height;
        int TEXT_MARGIN = 4;
        int IMAGE_MARGIN = 8;
        new TableColumn(this.table, 0).setWidth(96);
        new TableColumn(this.table, 0).setWidth(800);
        this.table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                UserProfile profile = (UserProfile)item.getData();
                int col = event.index;
                if (col == 0) {
                    event.width = 16 + imageWidth;
                    event.height = 16 + imageHeight;
                }
                if (col == 1) {
                    String text = String.format("%s", profile.getName());
                    Point textSize = event.gc.textExtent(text);
                    event.width = 8 + textSize.x;
                    event.height = 8 + textSize.y;
                }
            }
        });
        this.table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFEF;
                event.detail &= 2;
            }
        });
        this.table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                UserProfile profile = (UserProfile)item.getData();
                int col = event.index;
                if (col == 0) {
                    event.gc.drawImage(userImage, event.x + 8, event.y + 8);
                }
                if (col == 1) {
                    Font font = event.gc.getFont();
                    Font bold = ImageUtils.createFontLike(font, 1);
                    event.gc.setFont(bold);
                    String text = String.format("%s", profile.getName());
                    int yOffset = 0;
                    Point size = event.gc.textExtent(text);
                    yOffset = Math.max(0, (event.height - size.y) / 2);
                    event.gc.drawText(text, event.x + 4, event.y + yOffset, true);
                    event.gc.setFont(font);
                    bold.dispose();
                }
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProfileDialog.this.profileSelectionChanged();
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SelectProfileDialog.this.profileSelectionChanged();
                SelectProfileDialog.this.okPressed();
            }
        });
        this.refreshTableData();
        this.setTableSelection(this.profile);
        this.getShell().addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    event.doit = SelectProfileDialog.this.tryCancel();
                }
            }
        });
    }

    private void profileSelectionChanged() {
        int col = this.table.getSelectionIndex();
        if (col >= 0) {
            TableItem item = this.table.getItem(col);
            this.profile = (UserProfile)item.getData();
        } else {
            this.profile = null;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        Point result = WidgetSizeUtils.initialSize(this.getParentShell(), 72, 24);
        if (result != null) {
            return result;
        }
        return super.getInitialSize();
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle rect = this.getParentShell().getBounds();
        int x = rect.x + (rect.width - initialSize.x) / 2;
        int y = rect.y + (rect.height - initialSize.y) / 2;
        return new Point(x, y);
    }

    protected void okPressed() {
        if (this.tryLogin()) {
            this.savePreferences();
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        if (this.tryCancel()) {
            this.autoSelect = false;
            this.savePreferences();
            super.cancelPressed();
        }
    }

    private boolean tryLogin() {
        if (this.profile == null) {
            DialogUtils.showInfo(Messages.getString("SelectProfileDialog.validation.selectUserProfile"));
            return false;
        }
        String password = "";
        try {
            UserProfileService.getInstance().login(this.profile, password);
        }
        catch (UserProfileException e) {
            if ("ERR_INVALID_PASSWORD".equals(e.getMessage())) {
                DialogUtils.showError(Messages.getString("SelectProfileDialog.validation.invalidPassword"));
                return false;
            }
            DialogUtils.showError(String.format(Messages.getString("SelectProfileDialog.validation.loginError"), e.getMessage()));
            return false;
        }
        return true;
    }

    private boolean tryCancel() {
        return DialogUtils.showConfirm(Messages.getString("SelectProfileDialog.cancel.message"));
    }

    private void savePreferences() {
        SystemConfigService.getInstance().setString(PREF_LAST_PROFILE, this.profile != null ? this.profile.getName() : null);
        SystemConfigService.getInstance().setBoolean(PREF_AUTO_SELECT, this.autoSelect);
    }

    private void onCreateProfile() {
        CreateProfileDialog dialog = new CreateProfileDialog(this.getShell());
        if (dialog.open() == 0) {
            this.initProfiles();
            this.refreshTableData();
            this.setTableSelection(dialog.getProfile());
            this.table.setFocus();
        }
    }

    private void onDeleteProfile() {
        String msg;
        if (this.profile != null && DialogUtils.showConfirm(msg = String.format(Messages.getString("SelectProfileDialog.remove.message"), this.profile.getName()))) {
            try {
                UserProfileService.getInstance().removeUserProfile(this.profile);
                this.profile = null;
            }
            catch (UserProfileException e) {
                DialogUtils.showError(String.format(Messages.getString("SelectProfileDialog.removeError.message"), e.getMessage()));
            }
            this.initProfiles();
            this.refreshTableData();
            this.setTableSelection(this.profile);
            this.table.setFocus();
        }
    }

    public int open() {
        if (firstTime) {
            firstTime = false;
            if (this.autoSelect && this.profile != null && this.tryLogin()) {
                return 0;
            }
        }
        this.autoSelect = false;
        return super.open();
    }
}

