/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui.dialogs;

import geocentral.common.Messages;
import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.geocaching.SiteImageProviderService;
import geocentral.common.ui.dialogs.SiteLoginDialog;
import geocentral.common.ui.dialogs.WidgetSizeUtils;
import geocentral.common.ws.LoginAction;
import org.bacza.utils.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PasswordLoginDialog
extends SiteLoginDialog {
    private GeocacheSite site;
    private LoginAction loginAction;
    private Text txtUsername;
    private Text txtPassword;
    private String username;
    private String password;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public PasswordLoginDialog(Shell parentShell, GeocacheSite site, LoginAction loginAction) {
        super(parentShell);
        this.site = site;
        this.loginAction = loginAction;
    }

    @Override
    protected Control createPageControls(Composite parent) {
        this.setTitle(String.format(Messages.getString("PasswordLoginDialog.title"), this.site.getSiteName()));
        this.setMessage(Messages.getString("PasswordLoginDialog.message"));
        Image logo = SiteImageProviderService.getInstance().getSiteLogo(this.site);
        if (logo != null) {
            this.setTitleImage(logo);
        }
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblUsername = new Label(container, 0);
        lblUsername.setText(Messages.getString("PasswordLoginDialog.user"));
        this.txtUsername = new Text(container, 2048);
        this.txtUsername.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPassword = new Label(container, 0);
        lblPassword.setText(Messages.getString("PasswordLoginDialog.password"));
        this.txtPassword = new Text(container, 0x400800);
        this.txtPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtUsername.setText(StringUtils.nvl(this.username));
        return container;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        Point result = WidgetSizeUtils.initialSize(this.getParentShell(), 56, 18);
        if (result == null) {
            result = super.getInitialSize();
        }
        return result;
    }

    @Override
    public GeocacheSite getSite() {
        return this.site;
    }

    @Override
    protected LoginAction getLoginAction() {
        return this.loginAction;
    }

    @Override
    protected void loginPrepare(LoginAction action) {
        this.username = this.txtUsername.getText();
        this.password = this.txtPassword.getText();
        action.setUsername(this.username);
        action.setPassword(this.password);
    }

    @Override
    protected void loginSuccess() {
    }

    @Override
    protected void loginFailed() {
        this.txtPassword.setText("");
        this.txtUsername.setFocus();
        this.txtUsername.selectAll();
    }

    @Override
    protected void loginCancelled() {
        this.txtPassword.setText("");
        this.txtUsername.setFocus();
        this.txtUsername.selectAll();
    }
}

