/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui.dialogs;

import geocentral.common.Messages;
import geocentral.common.ui.dialogs.WidgetSizeUtils;
import org.bacza.utils.DesktopUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class NewVersionDialog
extends TitleAreaDialog {
    private final String date;
    private final String version;
    private final String url;

    public NewVersionDialog(Shell parentShell, String date, String version, String url) {
        super(parentShell);
        this.setShellStyle(67680);
        this.date = date;
        this.version = version;
        this.url = url;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("NewVersionDialog.title"));
        this.setMessage(Messages.getString("NewVersionDialog.message"));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.horizontalSpacing = 12;
        container.setLayout((Layout)gl_container);
        Label lblReleaseDate = new Label(container, 0);
        lblReleaseDate.setText(Messages.getString("NewVersionDialog.releaseDate"));
        Label lblReleaseDateValue = new Label(container, 0);
        lblReleaseDateValue.setText(this.date);
        Label lblVersion = new Label(container, 0);
        lblVersion.setText(Messages.getString("NewVersionDialog.version"));
        Label lblVersionValue = new Label(container, 0);
        lblVersionValue.setText(this.version);
        Label lblDownload = new Label(container, 0);
        lblDownload.setText(Messages.getString("NewVersionDialog.download"));
        Link link = new Link(container, 0);
        link.setText(String.format("<a>%s</a>", this.url));
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DesktopUtils.openUrl(event.text);
            }
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        Point result = WidgetSizeUtils.initialSize(this.getParentShell(), 54, 14);
        if (result != null) {
            return result;
        }
        return super.getInitialSize();
    }
}

