/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui.dialogs;

import geocentral.common.Messages;
import geocentral.common.app.LanguageService;
import geocentral.common.ui.dialogs.WidgetSizeUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LanguageDialog
extends TitleAreaDialog {
    private Combo combo;
    private String lang;
    private final List<String> langTags = new ArrayList<String>();
    private final List<String> langLabels = new ArrayList<String>();
    private int langIndex = -1;

    public String getLang() {
        return this.lang;
    }

    public LanguageDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(67680);
        this.init();
    }

    private void init() {
        this.langTags.addAll(LanguageService.getInstance().getAllLanguages());
        for (String tag : this.langTags) {
            this.langLabels.add(LanguageService.getInstance().getDisplayName(tag));
        }
        this.lang = LanguageService.getInstance().getLanguage();
        this.langIndex = this.langTags.indexOf(this.lang);
        if (this.langIndex == -1 && this.langTags.size() > 0) {
            this.langIndex = 0;
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("LanguageDialog.title"));
        this.setMessage(Messages.getString("LanguageDialog.message"));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblTag = new Label(container, 0);
        lblTag.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTag.setText(Messages.getString("LanguageDialog.language"));
        this.combo = new Combo(container, 8);
        this.combo.setItems(this.langLabels.toArray(new String[this.langLabels.size()]));
        this.combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.langIndex >= 0) {
            this.combo.select(this.langIndex);
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        Point result = WidgetSizeUtils.initialSize(this.getParentShell(), 56, 14);
        if (result != null) {
            return result;
        }
        return super.getInitialSize();
    }

    protected void okPressed() {
        if (this.checkInput()) {
            this.saveInput();
            super.okPressed();
        }
    }

    private boolean checkInput() {
        return true;
    }

    private void saveInput() {
        int index = this.combo.getSelectionIndex();
        if (index >= 0) {
            this.lang = this.langTags.get(index);
        }
    }
}

