/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui.dialogs;

import geocentral.common.Messages;
import geocentral.common.app.UserProfile;
import geocentral.common.app.UserProfileException;
import geocentral.common.app.UserProfileService;
import geocentral.common.ui.DialogUtils;
import geocentral.common.ui.dialogs.ProgressDialog;
import geocentral.common.ui.dialogs.WidgetSizeUtils;
import java.util.UUID;
import org.bacza.utils.FileUtils;
import org.bacza.utils.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateProfileDialog
extends ProgressDialog {
    private static final int MAX_PROFILE_NAME = 30;
    private UserProfile profile;
    private Text txtProfile;
    private Text txtPassword;
    private Text txtPassword2;

    public CreateProfileDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
    }

    public UserProfile getProfile() {
        return this.profile;
    }

    public void setProfile(UserProfile profile) {
        this.profile = profile;
    }

    @Override
    protected Control createPageControls(Composite parent) {
        this.setTitle(Messages.getString("CreateProfileDialog.title"));
        this.setMessage(Messages.getString("CreateProfileDialog.message"));
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblProfile = new Label(container, 0);
        lblProfile.setText(Messages.getString("CreateProfileDialog.name"));
        this.txtProfile = new Text(container, 2048);
        this.txtProfile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtProfile.setTextLimit(30);
        Label lblPassword = new Label(container, 0);
        lblPassword.setText(Messages.getString("CreateProfileDialog.password"));
        this.txtPassword = new Text(container, 0x400800);
        this.txtPassword.setEnabled(false);
        this.txtPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPassword2 = new Label(container, 0);
        lblPassword2.setText(Messages.getString("CreateProfileDialog.passwordConfirm"));
        this.txtPassword2 = new Text(container, 0x400800);
        this.txtPassword2.setEnabled(false);
        this.txtPassword2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.getShell().addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    event.doit = CreateProfileDialog.this.checkCancel();
                }
            }
        });
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        Point result = WidgetSizeUtils.initialSize(this.getParentShell(), 52, 16);
        if (result != null) {
            Point def = WidgetSizeUtils.defaultSize(this.getContents());
            WidgetSizeUtils.extendSize(def, 64, 64);
            return WidgetSizeUtils.maxSize(result, def);
        }
        return super.getInitialSize();
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle rect = this.getParentShell().getBounds();
        int x = rect.x + (rect.width - initialSize.x) / 2;
        int y = rect.y + (rect.height - initialSize.y) / 2;
        return new Point(x, y);
    }

    protected void okPressed() {
        if (this.checkClose()) {
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        if (this.checkCancel()) {
            super.cancelPressed();
        }
    }

    private boolean checkClose() {
        String pass2;
        this.profile = null;
        String name = this.txtProfile.getText();
        if (!name.equals(name.trim())) {
            name = name.trim();
            this.txtProfile.setText(name);
        }
        if (StringUtils.isEmpty(name)) {
            DialogUtils.showInfo(Messages.getString("CreateProfileDialog.enterProfileName"));
            this.txtProfile.setFocus();
            return false;
        }
        if (name.length() > 30) {
            DialogUtils.showInfo(String.format(Messages.getString("CreateProfileDialog.profileNameTooLong"), 30));
            this.txtProfile.setFocus();
            this.txtProfile.selectAll();
            return false;
        }
        if (!FileUtils.isFilenameValid(name)) {
            DialogUtils.showInfo(Messages.getString("CreateProfileDialog.profileNameInvalid"));
            this.txtProfile.setFocus();
            this.txtProfile.selectAll();
            return false;
        }
        String pass1 = this.txtPassword.getText();
        if (!pass1.equals(pass2 = this.txtPassword2.getText())) {
            DialogUtils.showInfo(Messages.getString("CreateProfileDialog.passwordsDontMatch"));
            this.txtPassword.setText("");
            this.txtPassword2.setText("");
            this.txtPassword.setFocus();
            return false;
        }
        try {
            UserProfile profile = new UserProfile(UUID.randomUUID().toString(), name);
            if (!pass1.isEmpty()) {
                profile.setPasswordPlainText(pass1);
            }
            UserProfileService.getInstance().registerUserProfile(profile);
            this.profile = profile;
        }
        catch (UserProfileException e) {
            this.profile = null;
            DialogUtils.showError(String.format(Messages.getString("CreateProfileDialog.profileCreateError"), e.getMessage()));
        }
        return this.profile != null;
    }

    private boolean checkCancel() {
        return true;
    }
}

