/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui.dialogs;

import org.bacza.utils.AssertUtils;
import org.eclipse.swt.graphics.Point;

public class CharMetrics {
    public static final Point DEFAULT_CHAR_SIZE = new Point(10, 24);
    private final Point size;

    public CharMetrics(Point size) {
        AssertUtils.notNull(size, "size");
        this.size = new Point(size.x, size.y);
    }

    public void setMinSize(int x, int y) {
        if (x >= 0 && x > this.size.x) {
            this.size.x = x;
        }
        if (y >= 0 && y > this.size.y) {
            this.size.y = y;
        }
    }

    public void setMaxSize(int x, int y) {
        if (x >= 0 && x < this.size.x) {
            this.size.x = x;
        }
        if (y >= 0 && y < this.size.y) {
            this.size.y = y;
        }
    }

    public int getCharWidth() {
        return this.size.x;
    }

    public int getCharHeight() {
        return this.size.y;
    }

    public int getWidth(int chars) {
        return chars * this.getCharWidth();
    }

    public int getHeight(int chars) {
        return chars * this.getCharHeight();
    }

    public String toString() {
        return String.format("width=%d, height=%d", this.size.x, this.size.y);
    }
}

