/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui;

import org.bacza.utils.AssertUtils;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public final class ImageUtils {
    public static Image createTransparentImage(Device device, int width, int height) {
        Image src = new Image(device, width, height);
        ImageData imageData = src.getImageData();
        imageData.transparentPixel = imageData.getPixel(0, 0);
        src.dispose();
        return new Image(device, imageData);
    }

    public static Image createTransparentImage2(Device device, int width, int height) {
        Image src = new Image(device, width, height);
        ImageData imageData = src.getImageData();
        imageData.transparentPixel = imageData.getPixel(0, 0);
        src.dispose();
        return new Image(device, imageData);
    }

    public static void saveAsPNG(Image image, String filename) {
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save(filename, 5);
    }

    public static Image resizeImage(Image image, int width, int height) {
        return ImageUtils.resizeImage(image, width, height, false);
    }

    public static Image resizeImage(Image image, int width, int height, boolean dispose) {
        Image result = new Image(image.getDevice(), image.getImageData().scaledTo(width, height));
        if (dispose) {
            image.dispose();
        }
        return result;
    }

    public static Font createFontLike(Font font, int style) {
        AssertUtils.notNull(font, "Font");
        return FontDescriptor.createFrom((Font)font).setStyle(style).createFont(font.getDevice());
    }
}

