/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui;

import geocentral.common.GlobalUtils;
import org.bacza.utils.ThreadUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class DisplayUtils {
    public static Display getDisplay() {
        return Display.getDefault();
    }

    public static Shell getShell() {
        Shell shell = DisplayUtils.getDisplay().getActiveShell();
        if (shell == null) {
            shell = (Shell)GlobalUtils.getInstance().getData("geocentral.main.shell");
        }
        return shell;
    }

    public static boolean isUIThread() {
        return Thread.currentThread() == DisplayUtils.getDisplay().getThread();
    }

    public static void syncExec(Runnable runnable) {
        DisplayUtils.getDisplay().syncExec(runnable);
    }

    public static void asyncExec(Runnable runnable) {
        DisplayUtils.getDisplay().asyncExec(runnable);
    }

    public static void asyncExecWithDelay(final long millis, final Runnable runnable) {
        ThreadUtils.exec(new Runnable(){

            @Override
            public void run() {
                ThreadUtils.sleep(millis);
                DisplayUtils.getDisplay().asyncExec(runnable);
            }
        });
    }

    public static void forceActive(final Shell shell) {
        if (shell != null) {
            shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    shell.forceActive();
                }
            });
        }
    }
}

