/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui;

import geocentral.common.Messages;
import geocentral.common.ui.DisplayUtils;
import geocentral.common.ui.ShellRunnable;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public final class DialogUtils {
    public static int showMessageBox(final String title, final String message, final int style) {
        ShellRunnable runnable = new ShellRunnable(){

            @Override
            public int run(Shell shell) {
                MessageBox dialog = new MessageBox(shell, style);
                if (title != null) {
                    dialog.setText(title);
                }
                if (message != null) {
                    dialog.setMessage(message);
                }
                return dialog.open();
            }
        };
        DisplayUtils.syncExec(runnable);
        return runnable.getResult();
    }

    public static boolean showConfirm(String message) {
        int style;
        String title = Messages.getString("DialogUtils.confirmation");
        int ret = DialogUtils.showMessageBox(title, message, style = 65828);
        return ret == 32;
    }

    public static boolean showQuestionYesNo(String message) {
        int style;
        String title = Messages.getString("DialogUtils.question");
        int ret = DialogUtils.showMessageBox(title, message, style = 65732);
        return ret == 64;
    }

    public static int showQuestionYesNoCancel(String message) {
        int style;
        String title = Messages.getString("DialogUtils.question");
        int ret = DialogUtils.showMessageBox(title, message, style = 65988);
        if (ret != 64 && ret != 128 && ret != 256) {
            ret = 256;
        }
        return ret;
    }

    public static boolean showInfo(String message) {
        int style;
        String title = Messages.getString("DialogUtils.information");
        int ret = DialogUtils.showMessageBox(title, message, style = 65570);
        return ret == 32;
    }

    public static boolean showWarning(String message) {
        int style;
        String title = Messages.getString("DialogUtils.warning");
        int ret = DialogUtils.showMessageBox(title, message, style = 65576);
        return ret == 32;
    }

    public static boolean showWarningOkCancel(String message) {
        int style;
        String title = Messages.getString("DialogUtils.warning");
        int ret = DialogUtils.showMessageBox(title, message, style = 65832);
        return ret == 32;
    }

    public static boolean showError(String message) {
        String title = Messages.getString("DialogUtils.error");
        return DialogUtils.showError(title, message);
    }

    public static boolean showError(String title, String message) {
        int style = 65569;
        int ret = DialogUtils.showMessageBox(title, message, style);
        return ret == 32;
    }

    public static boolean showErrorOkCancel(String message) {
        String title = Messages.getString("DialogUtils.error");
        return DialogUtils.showErrorOkCancel(title, message);
    }

    public static boolean showErrorOkCancel(String title, String message) {
        int style = 65825;
        int ret = DialogUtils.showMessageBox(title, message, style);
        return ret == 32;
    }
}

