/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui;

import geocentral.common.ui.ICustomDrawingConfigurer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;

public class CustomDrawingSupport2 {
    private ICustomDrawingConfigurer configurer;

    public CustomDrawingSupport2() {
        this(null);
    }

    public CustomDrawingSupport2(ICustomDrawingConfigurer configurer) {
        this.configurer = configurer;
    }

    public ICustomDrawingConfigurer getConfigurer() {
        return this.configurer;
    }

    public void setConfigurer(ICustomDrawingConfigurer configurer) {
        this.configurer = configurer;
    }

    protected boolean isCustomDrawn(int column) {
        if (this.configurer != null) {
            return this.configurer.isCustomDrawn(column);
        }
        return false;
    }

    public void handleEventMeasureItem(Event event) {
    }

    public void handleEventEraseItem(Event event) {
        if (this.isCustomDrawn(event.index)) {
            event.detail &= 0xFFFFFFEF;
        }
    }

    public void handleEventPaintItem(Event event) {
        TableItem item;
        Image image;
        if (this.isCustomDrawn(event.index) && (image = (item = (TableItem)event.item).getImage(event.index)) != null) {
            Rectangle rec = item.getBounds(event.index);
            int imgHeight = image.getImageData().height;
            int xOffset = 4;
            int yOffset = Math.max(0, (rec.height - imgHeight) / 2);
            event.gc.drawImage(image, rec.x + xOffset, rec.y + yOffset);
        }
    }
}

