/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui;

import geocentral.common.ui.ICustomDrawingConfigurer;
import geocentral.common.ui.ImageArray;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;

public class CustomDrawingSupport {
    private ICustomDrawingConfigurer configurer;

    public CustomDrawingSupport() {
        this(null);
    }

    public CustomDrawingSupport(ICustomDrawingConfigurer configurer) {
        this.configurer = configurer;
    }

    public ICustomDrawingConfigurer getConfigurer() {
        return this.configurer;
    }

    public void setConfigurer(ICustomDrawingConfigurer configurer) {
        this.configurer = configurer;
    }

    protected boolean isCustomDrawn(int column) {
        if (this.configurer != null) {
            return this.configurer.isCustomDrawn(column);
        }
        return false;
    }

    public void handleEventMeasureItem(Event event) {
    }

    public void handleEventEraseItem(Event event) {
        if (this.isCustomDrawn(event.index)) {
            event.detail &= 0xFFFFFFEF;
        }
    }

    public void handleEventPaintItem(Event event) {
        TableItem item;
        Image image;
        if (this.isCustomDrawn(event.index) && (image = this.getCustomImage(item = (TableItem)event.item, event.index)) != null) {
            Rectangle rect = item.getBounds(event.index);
            int imgHeight = image.getImageData().height;
            int xOffset = 4;
            int yOffset = Math.max(0, (rect.height - imgHeight) / 2);
            event.gc.drawImage(image, rect.x + xOffset, rect.y + yOffset);
        }
    }

    private Image getCustomImage(TableItem item, int index) {
        Object data = item.getData();
        if (data instanceof ImageArray) {
            return ((ImageArray)data).getImage(index);
        }
        return null;
    }
}

