/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.stats;

import geocentral.common.data.FieldNoteItem;
import geocentral.common.geocaching.GeocacheLogType;
import geocentral.common.geocaching.GeocacheLogTypeUtils;
import geocentral.common.stats.AbstractGroupedCounter;
import geocentral.common.stats.FieldNoteIntCounter;

public class GeocacheLogTypeCounter
extends AbstractGroupedCounter<FieldNoteItem, GeocacheLogType, FieldNoteIntCounter> {
    private final boolean aggregateFinds;

    public GeocacheLogTypeCounter(boolean aggregateFinds) {
        this.aggregateFinds = aggregateFinds;
    }

    @Override
    protected FieldNoteIntCounter createCounter() {
        return new FieldNoteIntCounter();
    }

    @Override
    public GeocacheLogType getGroupKey(FieldNoteItem item) {
        if (item != null) {
            return item.getLogType();
        }
        return null;
    }

    @Override
    public GeocacheLogType convertGroupKey(GeocacheLogType group) {
        if (this.aggregateFinds && GeocacheLogTypeUtils.isFind(group)) {
            return GeocacheLogType.FOUND_IT;
        }
        return group;
    }

    public String toString() {
        return String.format("Total: %d, Finds: %d, DNFs: %d, Attends: %d", this.getValue(), this.getValueByGroup(GeocacheLogType.FOUND_IT), this.getValueByGroup(GeocacheLogType.DNF), this.getValueByGroup(GeocacheLogType.ATTENDED));
    }
}

