/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;

public final class SQLUtils {
    public static void executeUpdate(Connection conn, String sql) throws SQLException {
        AssertUtils.notNull(conn, "Connection");
        AssertUtils.notNull(sql, "SQL");
        if (StringUtils.notEmpty(sql)) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Statement st = conn.createStatement();){
                st.setQueryTimeout(30);
                st.executeUpdate(sql);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static void setString(PreparedStatement st, int index, String value) throws SQLException {
        AssertUtils.notNull(st, "Prepared Statement");
        if (value == null) {
            st.setNull(index, 12);
        } else {
            st.setString(index, value);
        }
    }

    public static void setDate(PreparedStatement st, int index, Date value) throws SQLException {
        AssertUtils.notNull(st, "Prepared Statement");
        if (value == null) {
            st.setNull(index, 91);
        } else {
            st.setDate(index, new java.sql.Date(value.getTime()));
        }
    }

    public static void setDouble(PreparedStatement st, int index, Double value) throws SQLException {
        AssertUtils.notNull(st, "Prepared Statement");
        if (value == null) {
            st.setNull(index, 8);
        } else {
            st.setDouble(index, value);
        }
    }

    public static void setInteger(PreparedStatement st, int index, Integer value) throws SQLException {
        AssertUtils.notNull(st, "Prepared Statement");
        if (value == null) {
            st.setNull(index, 4);
        } else {
            st.setInt(index, value);
        }
    }

    public static void setBoolean(PreparedStatement st, int index, Boolean value) throws SQLException {
        AssertUtils.notNull(st, "Prepared Statement");
        if (value == null) {
            st.setNull(index, 16);
        } else {
            st.setBoolean(index, value);
        }
    }

    public static String getString(ResultSet rs, int index) throws SQLException {
        AssertUtils.notNull(rs, "Result Set");
        return rs.getString(index);
    }

    public static Date getDate(ResultSet rs, int index) throws SQLException {
        AssertUtils.notNull(rs, "Result Set");
        return rs.getDate(index);
    }

    public static Integer getInteger(ResultSet rs, int index) throws SQLException {
        AssertUtils.notNull(rs, "Result Set");
        int value = rs.getInt(index);
        return rs.wasNull() ? null : Integer.valueOf(value);
    }

    public static Double getDouble(ResultSet rs, int index) throws SQLException {
        AssertUtils.notNull(rs, "Result Set");
        double value = rs.getDouble(index);
        return rs.wasNull() ? null : Double.valueOf(value);
    }

    public static Boolean getBoolean(ResultSet rs, int index) throws SQLException {
        AssertUtils.notNull(rs, "Result Set");
        boolean value = rs.getBoolean(index);
        return rs.wasNull() ? null : Boolean.valueOf(value);
    }

    public static int getIntegerPrimitive(ResultSet rs, int index) throws SQLException {
        AssertUtils.notNull(rs, "Result Set");
        return rs.getInt(index);
    }

    public static double getDoublePrimitive(ResultSet rs, int index) throws SQLException {
        AssertUtils.notNull(rs, "Result Set");
        return rs.getDouble(index);
    }

    public static boolean getBooleanPrimitive(ResultSet rs, int index) throws SQLException {
        AssertUtils.notNull(rs, "Result Set");
        return rs.getBoolean(index);
    }
}

