/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.bacza.utils.AssertUtils;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteOpenMode;

public final class ConnectionManager {
    private static final ConnectionManager instance = new ConnectionManager();

    private ConnectionManager() {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static ConnectionManager getInstance() {
        return instance;
    }

    public Connection getConnection(String databaseName) throws SQLException {
        return this.getConnection(databaseName, false);
    }

    public Connection getConnection(String databaseName, boolean create) throws SQLException {
        AssertUtils.notNull(databaseName, "Database name");
        SQLiteConfig cfg = new SQLiteConfig();
        if (!create) {
            cfg.resetOpenMode(SQLiteOpenMode.CREATE);
        }
        String url = String.format("jdbc:sqlite:%s", databaseName);
        Connection connection = DriverManager.getConnection(url, cfg.toProperties());
        connection.setAutoCommit(false);
        return connection;
    }
}

