/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.scripting;

import geocentral.common.app.StorageService;
import geocentral.common.data.IChangeEventSource;
import geocentral.common.scripting.ScriptInfo;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.FileUtils;
import org.bacza.utils.ObjectUtils;
import org.bacza.utils.StringUtils;

public final class ScriptingManager
implements IChangeEventSource {
    private static final Log log = LogFactory.getLog(ScriptingManager.class);
    private static final ScriptEngineManager manager = new ScriptEngineManager();
    private static final Map<String, String> langMap = new HashMap<String, String>();
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private final Map<String, ScriptInfo> infosById = new HashMap<String, ScriptInfo>();
    private final Map<String, Invocable> invocablesById = new HashMap<String, Invocable>();
    private static final ScriptingManager instance;

    static {
        langMap.put("js", "rhino");
        instance = new ScriptingManager();
    }

    public static ScriptingManager getInstance() {
        return instance;
    }

    private ScriptingManager() {
        this.registerScript(new ScriptInfo("geocentral.scripting.menu.view", "TableViewConfig.js", "js"));
        this.reloadAll();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void notifyChange() {
        this.notifyChange("all");
    }

    private void notifyChange(String id) {
        this.changeSupport.firePropertyChange(id, 0, 1);
    }

    public void registerScript(ScriptInfo info) {
        if (info != null) {
            this.infosById.put(info.getId(), info);
        }
    }

    public void reloadAll() {
        this.invocablesById.clear();
        for (String id : this.infosById.keySet()) {
            this.loadScript(id);
        }
    }

    public void loadScript(String id) {
        if (StringUtils.notEmpty(id)) {
            Invocable invOld = null;
            Invocable invNew = null;
            try {
                try {
                    invOld = this.invocablesById.remove(id);
                    invNew = this.loadScriptImpl(this.infosById.get(id));
                    if (invNew != null) {
                        this.invocablesById.put(id, invNew);
                    }
                }
                catch (IOException e) {
                    log.debug((Object)"Exception", (Throwable)e);
                    if (!ObjectUtils.equals(invOld, invNew)) {
                        this.notifyChange(id);
                    }
                }
                catch (ScriptException e) {
                    log.debug((Object)"Exception", (Throwable)e);
                    if (!ObjectUtils.equals(invOld, invNew)) {
                        this.notifyChange(id);
                    }
                }
            }
            finally {
                if (!ObjectUtils.equals(invOld, invNew)) {
                    this.notifyChange(id);
                }
            }
        }
    }

    private Invocable loadScriptImpl(ScriptInfo info) throws IOException, ScriptException {
        if (info == null) {
            return null;
        }
        String filename = StorageService.getInstance().getAppHomePath(info.getFilename());
        if (!FileUtils.fileExists(filename)) {
            return null;
        }
        String script = FileUtils.readFileAsString(filename);
        ScriptEngine engine = null;
        String lang = info.getLang();
        if (lang != null && (lang = langMap.get(lang)) != null) {
            engine = manager.getEngineByName(lang);
        }
        if (engine == null) {
            log.debug((Object)String.format("Unsupported scripting language: %s", info.getLang()));
            return null;
        }
        if (!(engine instanceof Invocable)) {
            log.debug((Object)String.format("Scripting engine does NOT implement Invocable: %s", info.getLang()));
            return null;
        }
        engine.eval(script);
        log.debug((Object)String.format("Script loaded: %s", info.getId()));
        return (Invocable)((Object)engine);
    }

    public <T> T getInterface(String id, Class<T> clazz) {
        AssertUtils.notNull(id, "Script ID");
        AssertUtils.notNull(clazz, "Interface class");
        Invocable inv = this.invocablesById.get(id);
        if (inv != null) {
            return inv.getInterface(clazz);
        }
        return null;
    }
}

