/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.plugins;

import geocentral.common.GlobalUtils;
import geocentral.common.actions.ActionContext;
import geocentral.common.actions.AppContext;
import geocentral.common.actions.IActionContext;
import geocentral.common.plugins.ActionMeta;
import geocentral.common.plugins.ContextData;
import geocentral.common.plugins.ContextRepo;
import geocentral.common.plugins.ExecData;
import geocentral.common.plugins.IAsyncPlugin;
import geocentral.common.plugins.IPlugin;
import geocentral.common.plugins.IPluginAction;
import geocentral.common.ui.DisplayUtils;
import geocentral.common.ui.ThreadSafeProgressMonitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.StatusLineManager;

public final class PluginExecutor2 {
    private static final String DEFAULT_JOB_NAME = "Background task";
    private static final PluginExecutor2 instance = new PluginExecutor2();
    public static final int MAX_THREADS = 1;
    private Object lock = new Object();
    private int allRunningActions = 0;
    private LinkedList<IAsyncPlugin> pendingPlugins = new LinkedList();
    private Map<IAsyncPlugin, ExecData> execDataByPlugin = new HashMap<IAsyncPlugin, ExecData>();
    private ContextRepo contextRepo = new ContextRepo();

    public static PluginExecutor2 getInstance() {
        return instance;
    }

    private PluginExecutor2() {
    }

    private ExecData getExecData(IAsyncPlugin plugin) {
        ExecData result = this.execDataByPlugin.get(plugin);
        if (result == null) {
            ContextData contextData = this.contextRepo.getContextData(plugin.getConcurrencyContext());
            result = new ExecData(contextData);
            this.execDataByPlugin.put(plugin, result);
        }
        return result;
    }

    private void enqueueAction(IAsyncPlugin plugin, ActionMeta actionMeta) {
        ExecData data = this.getExecData(plugin);
        int countBefore = data.getPendingActionCount();
        data.addPendingAction(actionMeta);
        int countAfter = data.getPendingActionCount();
        if (countBefore != countAfter) {
            this.pendingPlugins.addLast(plugin);
        }
    }

    private void executeAction(final IAsyncPlugin plugin, ActionMeta actionMeta) {
        final IPluginAction pluginAction = actionMeta.getPluginAction();
        final AppContext appContext = actionMeta.getAppContext();
        String name = plugin.getTaskName();
        if (name == null && (name = plugin.getName()) == null) {
            name = DEFAULT_JOB_NAME;
        }
        final ThreadSafeProgressMonitor monitor = new ThreadSafeProgressMonitor(this.getAppProgressMonitor());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IStatus status = Status.OK_STATUS;
                try {
                    ActionContext context = new ActionContext(monitor, appContext);
                    pluginAction.execute(plugin, context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    status = new Status(4, "unknown", e.getMessage(), (Throwable)e);
                }
                try {
                    appContext.cleanup(status);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PluginExecutor2.this.executeDone(plugin);
            }
        };
        new Thread(runnable).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDone(IAsyncPlugin plugin) {
        IAsyncPlugin nextPlugin = null;
        ActionMeta nextAction = null;
        Object object = this.lock;
        synchronized (object) {
            ExecData data = this.getExecData(plugin);
            data.actionStopped();
            if (this.allRunningActions > 0) {
                --this.allRunningActions;
            }
            if (this.allRunningActions >= 1) {
                return;
            }
            Iterator iter = this.pendingPlugins.iterator();
            while (iter.hasNext()) {
                nextPlugin = (IAsyncPlugin)iter.next();
                ExecData nextData = this.getExecData(nextPlugin);
                if (!nextData.canExecuteAction()) continue;
                iter.remove();
                nextAction = nextData.getPendingAction();
                if (nextAction == null) break;
                nextData.actionStarted();
                ++this.allRunningActions;
                break;
            }
        }
        if (nextPlugin != null && nextAction != null) {
            this.executeAction(nextPlugin, nextAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(IAsyncPlugin plugin, ActionMeta actionMeta) {
        Object object = this.lock;
        synchronized (object) {
            if (this.allRunningActions >= 1) {
                this.enqueueAction(plugin, actionMeta);
                return;
            }
            ExecData data = this.getExecData(plugin);
            if (!data.canExecuteAction()) {
                this.enqueueAction(plugin, actionMeta);
                return;
            }
            data.actionStarted();
            ++this.allRunningActions;
        }
        this.executeAction(plugin, actionMeta);
    }

    public void executeSync(IPlugin plugin, IPluginAction action) {
        if (plugin != null && action != null) {
            action.execute(plugin, null);
        }
    }

    public void executeSync(IAsyncPlugin plugin, IPluginAction action, IActionContext context) {
        if (plugin != null && action != null && context != null) {
            action.execute(plugin, context);
        }
    }

    public void executeAsync(IAsyncPlugin plugin, IPluginAction action, AppContext appContext) {
        if (plugin != null && action != null) {
            ActionMeta actionMeta = new ActionMeta(action, appContext);
            this.execute(plugin, actionMeta);
        }
    }

    protected IProgressMonitor getAppProgressMonitor() {
        final StatusLineManager status = (StatusLineManager)GlobalUtils.getInstance().getData("geocentral.main.status");
        DisplayUtils.syncExec(new Runnable(){

            @Override
            public void run() {
                status.setCancelEnabled(true);
            }
        });
        return status.getProgressMonitor();
    }
}

