/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.items;

import geocentral.common.items.TrackSegment;
import geocentral.common.map.Bounds;
import geocentral.common.map.Coords;
import geocentral.common.map.IBoundedMapItem;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.bacza.utils.ObjectUtils;

public class TrackItem
implements IBoundedMapItem {
    public static final String ID = "geocentral.common.items.TrackItem";
    private static final long serialVersionUID = -1284811823100376758L;
    private Coords startPoint;
    private Bounds bounds = new Bounds();
    private String name;
    private String description;
    private String link;
    private int waypointCount = 0;
    private double length;
    private double ascent;
    private double descent;
    private Date createdDate;
    private Date modifiedDate;
    private String trackType;
    private List<TrackSegment> segments;

    public TrackItem() {
        this.startPoint = new Coords();
        this.segments = new LinkedList<TrackSegment>();
    }

    public int hashCode() {
        return ObjectUtils.hashCode(this.name);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (ObjectUtils.equalClass(this, obj)) {
            TrackItem other = (TrackItem)obj;
            result = ObjectUtils.equals(this.name, other.name);
        }
        return result;
    }

    public String toString() {
        return String.format("[%s] [%s]", this.name, this.startPoint);
    }

    @Override
    public String getItemId() {
        return this.name;
    }

    @Override
    public Coords getCoords() {
        return this.getStartPoint();
    }

    @Override
    public void setCoords(Coords latlon) {
        this.startPoint = latlon;
    }

    @Override
    public Coords getStartPoint() {
        return this.startPoint;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<TrackSegment> getSegments() {
        return this.segments;
    }

    public int getSegmentCount() {
        return this.segments.size();
    }

    public void addTrackSegment(TrackSegment segment) {
        if (segment != null) {
            this.segments.add(segment);
            this.bounds.extend(segment.getBounds());
            this.waypointCount += segment.getWaypointCount();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public int getWaypointCount() {
        return this.waypointCount;
    }

    public void setWaypointCount(int waypointCount) {
        this.waypointCount = waypointCount;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date date) {
        this.createdDate = date;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public double getAscent() {
        return this.ascent;
    }

    public void setAscent(double ascent) {
        this.ascent = ascent;
    }

    public double getDescent() {
        return this.descent;
    }

    public void setDescent(double descent) {
        this.descent = descent;
    }

    public String getTrackType() {
        return this.trackType;
    }

    public void setTrackType(String trackType) {
        this.trackType = trackType;
    }
}

