/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.geocaching.api;

import geocentral.api.groundspeak.ui.EditFieldNotePasswordDialog;
import geocentral.common.Messages;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.geocaching.api.PostLogException;
import geocentral.common.geocaching.api.PostLogExceptionHandler;
import geocentral.common.ui.DialogUtils;
import geocentral.common.ui.DisplayUtils;

public class PasswordExceptionHandler
implements PostLogExceptionHandler {
    private final boolean passRequired;

    public PasswordExceptionHandler(boolean passRequired) {
        this.passRequired = passRequired;
    }

    @Override
    public boolean handle(FieldNoteItem item, PostLogException e) {
        String str = this.passRequired ? Messages.getString("PasswordExceptionHandler.messagePassRequired") : Messages.getString("PasswordExceptionHandler.messagePassInvalid");
        String msg = String.format(str, item.getGeocacheCode(), item.getGeocacheName());
        if (DialogUtils.showErrorOkCancel(msg)) {
            EditFieldNotePasswordDialog dialog = new EditFieldNotePasswordDialog(DisplayUtils.getShell());
            dialog.setPassword(item.getOptPassword());
            if (dialog.open() == 0) {
                item.setOptPassword(dialog.getPassword());
                item.notifyChange();
                return true;
            }
        }
        return false;
    }
}

