/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.geocaching.api;

import geocentral.api.groundspeak.GcGeocachingApiProvider;
import geocentral.api.opencaching.OcGeocachingApiProvider;
import geocentral.api.opencaching.OpGeocachingApiProvider;
import geocentral.common.app.UserProfile;
import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.geocaching.api.IGeocachingApi;
import geocentral.common.geocaching.api.IGeocachingApiProvider;
import geocentral.common.geocaching.api.LogOptions;
import java.util.HashMap;
import java.util.Map;
import org.bacza.utils.AssertUtils;

public final class GeocachingApiService {
    private static final GeocachingApiService instance = new GeocachingApiService();
    private final Map<GeocacheSite, IGeocachingApiProvider> providersBySite = new HashMap<GeocacheSite, IGeocachingApiProvider>();
    private final Map<GeocacheSite, LogOptions> optionsBySite = new HashMap<GeocacheSite, LogOptions>();

    public static GeocachingApiService getInstance() {
        return instance;
    }

    private GeocachingApiService() {
        this.registerProvider(new GcGeocachingApiProvider());
        this.registerProvider(new OcGeocachingApiProvider());
        this.registerProvider(new OpGeocachingApiProvider());
    }

    public synchronized void registerProvider(IGeocachingApiProvider provider) {
        AssertUtils.notNull(provider, "provider");
        GeocacheSite site = provider.getSite();
        AssertUtils.notNull((Object)site, "site");
        LogOptions options = provider.getLogOptions();
        AssertUtils.notNull(options, "options");
        this.providersBySite.put(site, provider);
        this.optionsBySite.put(site, options);
    }

    public synchronized LogOptions getLogOptions(GeocacheSite site) {
        AssertUtils.notNull((Object)site, "site");
        return this.optionsBySite.get((Object)site);
    }

    public synchronized IGeocachingApi createApi(GeocacheSite site, UserProfile profile) {
        AssertUtils.notNull((Object)site, "site");
        AssertUtils.notNull(profile, "profile");
        IGeocachingApiProvider provider = this.providersBySite.get((Object)site);
        if (provider != null) {
            return provider.createApi(profile);
        }
        return null;
    }
}

