/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.geocaching;

import geocentral.common.geocaching.GeocachingItemFactoryService;
import geocentral.common.geocaching.IGeocachingItemFactory;
import geocentral.common.items.Geocache;
import geocentral.common.items.GeocacheLog;
import geocentral.common.items.GeocacheUser;

public final class GeocachingItemFactoryUtils {
    private static final GeocachingItemFactoryService factoryService = GeocachingItemFactoryService.getInstance();

    public static String getSiteByGeocacheCode(String code) {
        return factoryService.getSiteByGeocacheCode(code);
    }

    public static Geocache createGeocache(String site) {
        IGeocachingItemFactory itemFactory = factoryService.getFactory(site);
        if (itemFactory != null) {
            return itemFactory.createGeocache();
        }
        return null;
    }

    public static GeocacheUser createGeocacheUser(String site) {
        IGeocachingItemFactory itemFactory = factoryService.getFactory(site);
        if (itemFactory != null) {
            return itemFactory.createGeocacheUser();
        }
        return null;
    }

    public static GeocacheLog createGeocacheLog(String site) {
        IGeocachingItemFactory itemFactory = factoryService.getFactory(site);
        if (itemFactory != null) {
            return itemFactory.createGeocacheLog();
        }
        return null;
    }
}

