/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.geocaching;

import geocentral.api.groundspeak.items.GsGeocachingItemFactoryPlugin;
import geocentral.api.opencaching.items.OPGeocachingItemFactoryPlugin;
import geocentral.common.geocaching.IGeocachingItemFactory;
import geocentral.common.geocaching.IGeocachingItemFactoryPlugin;
import geocentral.common.plugins.AbstractPluginService;
import java.util.HashMap;
import java.util.Map;
import org.bacza.utils.StringUtils;

public final class GeocachingItemFactoryService
extends AbstractPluginService<IGeocachingItemFactoryPlugin> {
    public static final String EXT_ID = "geocentral.common.geocachingItemFactories";
    private static final GeocachingItemFactoryService instance = new GeocachingItemFactoryService();
    private Map<String, IGeocachingItemFactory> map = new HashMap<String, IGeocachingItemFactory>();

    public static GeocachingItemFactoryService getInstance() {
        return instance;
    }

    private GeocachingItemFactoryService() {
        this.loadConfiguration(EXT_ID);
        this.initializePlugin(new GsGeocachingItemFactoryPlugin());
        this.initializePlugin(new OPGeocachingItemFactoryPlugin());
    }

    @Override
    protected void initializePlugin(IGeocachingItemFactoryPlugin plugin) {
        if (plugin != null) {
            this.registerFactory(plugin.createFactory());
        }
    }

    private String getSiteKey(String site) {
        return StringUtils.toUpperCase(site);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFactory(IGeocachingItemFactory factory) {
        String site;
        if (factory != null && StringUtils.notEmpty(site = this.getSiteKey(factory.getSite()))) {
            Map<String, IGeocachingItemFactory> map = this.map;
            synchronized (map) {
                if (!this.map.containsKey(site)) {
                    this.map.put(site, factory);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSiteByGeocacheCode(String code) {
        if (StringUtils.notEmpty(code)) {
            Map<String, IGeocachingItemFactory> map = this.map;
            synchronized (map) {
                for (Map.Entry<String, IGeocachingItemFactory> entry : this.map.entrySet()) {
                    if (!entry.getValue().isGeocacheCodeSupported(code)) continue;
                    return entry.getKey();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGeocachingItemFactory getFactory(String site) {
        IGeocachingItemFactory result = null;
        if (StringUtils.notEmpty(site)) {
            Map<String, IGeocachingItemFactory> map = this.map;
            synchronized (map) {
                result = this.map.get(this.getSiteKey(site));
            }
        }
        return result;
    }
}

