/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.geocaching;

public enum GeocacheSize {
    NONE(0, "None"),
    NANO(1, "Nano"),
    MICRO(2, "Micro"),
    SMALL(3, "Small"),
    REGULAR(4, "Regular"),
    LARGE(5, "Large"),
    XLARGE(6, "Very Large"),
    OTHER(7, "Other"),
    NOTCHOSEN(8, "Not chosen");

    private final int value;
    private final String text;

    private GeocacheSize(int value, String text) {
        this.value = value;
        this.text = text;
    }

    public int value() {
        return this.value;
    }

    public String text() {
        return this.text;
    }

    public String toString() {
        return this.text;
    }

    public static GeocacheSize getSize(int value) {
        GeocacheSize[] geocacheSizeArray = GeocacheSize.values();
        int n = geocacheSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GeocacheSize s = geocacheSizeArray[n2];
            if (s.value() == value) {
                return s;
            }
            ++n2;
        }
        return OTHER;
    }

    public static GeocacheSize getSize(double value) {
        if (value == 0.0) {
            return NONE;
        }
        if (value < 1.0) {
            return NANO;
        }
        int v = (int)(value + 0.49);
        return GeocacheSize.getSize(v);
    }

    public static String getText(GeocacheSize size) {
        return size != null ? size.text() : null;
    }

    public static GeocacheSize parse(String str) {
        if (str != null) {
            GeocacheSize[] geocacheSizeArray = GeocacheSize.values();
            int n = geocacheSizeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GeocacheSize value = geocacheSizeArray[n2];
                if (str.equals(value.text)) {
                    return value;
                }
                ++n2;
            }
        }
        return null;
    }
}

