/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.geocaching;

public enum GeocacheLogType {
    FOUND_IT("Found it"),
    DNF("Didn't find it"),
    WRITE_NOTE("Write note"),
    WILL_ATTEND("Will Attend"),
    ATTENDED("Attended"),
    NEEDS_ARCH("Needs Archived"),
    NEEDS_MAINT("Needs Maintenance"),
    OWNER_MAINT("Owner Maintenance"),
    WEBCAM_PHOTO_TAKEN("Webcam Photo Taken"),
    UNATTEMPTED("Unattempted"),
    ENABLE_LISTING("Enable Listing"),
    DISABLE_LISTING("Disable Listing");

    private final String text;

    private GeocacheLogType(String text) {
        this.text = text;
    }

    public String text() {
        return this.text;
    }

    public String toString() {
        return this.text;
    }

    public static String getText(GeocacheLogType logType) {
        return logType != null ? logType.text() : null;
    }

    public static GeocacheLogType parse(String str) {
        if (str != null) {
            GeocacheLogType[] geocacheLogTypeArray = GeocacheLogType.values();
            int n = geocacheLogTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GeocacheLogType value = geocacheLogTypeArray[n2];
                if (str.equals(value.text)) {
                    return value;
                }
                ++n2;
            }
        }
        return null;
    }
}

