/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.geocaching;

import java.util.HashMap;
import java.util.Map;
import org.bacza.data.parsers.ParseAssert;
import org.bacza.data.parsers.ParseException;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;

public class GeocacheLogToken {
    private String name;
    private String params;
    private Map<String, String> paramsByName;

    public GeocacheLogToken(String name, String params) throws ParseException {
        this.name = StringUtils.trim(name);
        this.params = StringUtils.trim(params);
        this.paramsByName = new HashMap<String, String>();
        AssertUtils.notEmpty(this.name, "Token name");
        this.processParams();
    }

    private void processParams() throws ParseException {
        if (StringUtils.notEmpty(this.params)) {
            String[] tokens;
            String[] stringArray = tokens = this.params.split(",");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                this.processParam(StringUtils.trim(token));
                ++n2;
            }
        }
    }

    private void processParam(String param) throws ParseException {
        if (StringUtils.notEmpty(param)) {
            String[] tokens = param.split("=");
            ParseAssert.check(tokens.length == 2, 1000);
            String key = StringUtils.trim(tokens[0]);
            String value = StringUtils.trim(tokens[1]);
            ParseAssert.notEmpty(key, 1010);
            ParseAssert.notEmpty(value, 1020);
            this.paramsByName.put(key, value);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getParams() {
        return this.params;
    }

    public String getParam(String key) {
        if (key != null) {
            return this.paramsByName.get(key);
        }
        return null;
    }

    public String toString() {
        return String.format("%s %s", this.name, this.paramsByName);
    }
}

