/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.files;

import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.FieldNoteType;
import geocentral.common.geocaching.DefaultGeocacheLogTypeMapper;
import geocentral.common.geocaching.GeocacheCodeService;
import geocentral.common.geocaching.GeocacheLogType;
import geocentral.common.geocaching.GeocacheMapperUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.bacza.data.parsers.ParseAssert;
import org.bacza.data.parsers.ParseException;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.DateParser;
import org.bacza.utils.FileInputStreamProvider;
import org.bacza.utils.InputStreamProvider;
import org.bacza.utils.StringInputStreamProvider;
import org.bacza.utils.StringUtils;
import org.bacza.utils.UnicodeReader;

public class FieldNoteReader {
    private static final String[] ENC_8_16 = new String[]{"UTF-8", "UTF-16LE"};
    private static final String[] ENC_16_8 = new String[]{"UTF-16LE", "UTF-8"};
    private final boolean strictMode;
    private final DateParser dateParser;
    private final List<FieldNoteItem> items;

    public FieldNoteReader(boolean strictMode, DateParser dateParser) {
        this.strictMode = strictMode;
        this.dateParser = dateParser;
        this.items = new LinkedList<FieldNoteItem>();
    }

    public void readFile(String filename) throws IOException, ParseException {
        AssertUtils.notNull(filename, "File name");
        this.readStream(ENC_16_8, new FileInputStreamProvider(filename));
    }

    public void readString(String data) throws IOException, ParseException {
        AssertUtils.notNull(data, "Data");
        this.readStream(ENC_8_16, new StringInputStreamProvider(data));
    }

    protected void readStream(String[] encodings, InputStreamProvider isp) throws IOException, ParseException {
        boolean tryAgain = true;
        int i = 0;
        while (i < encodings.length && tryAgain) {
            block3: {
                try {
                    this.items.clear();
                    this.readStreamImpl(isp, encodings[i]);
                    tryAgain = false;
                }
                catch (ParseException pe) {
                    if (this.items.size() <= 0) break block3;
                    throw pe;
                }
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readStreamImpl(InputStreamProvider isp, String defaultEncoding) throws IOException, ParseException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            UnicodeReader ur = new UnicodeReader(isp.createInputStream(), defaultEncoding);
            try {
                try (BufferedReader br = new BufferedReader(ur);){
                    String line;
                    FieldNoteItem item = this.createFieldNoteItem();
                    boolean cont = false;
                    DefaultGeocacheLogTypeMapper logTypeMapper = GeocacheMapperUtils.getLogTypeMapper();
                    while ((line = br.readLine()) != null) {
                        String token;
                        if (cont) {
                            token = line;
                            if (StringUtils.endsWith(token, "\"", true)) {
                                token = token.substring(0, token.lastIndexOf("\""));
                                cont = false;
                            }
                            item.setLogText(String.format("%s%n%s", item.getLogText(), token));
                        } else {
                            if (!StringUtils.notEmpty(StringUtils.trim(line))) continue;
                            String[] fields = line.split(",", 4);
                            if (this.strictMode) {
                                ParseAssert.check(fields.length == 4, 1000);
                            } else {
                                ParseAssert.check(fields.length >= 1, 1000);
                            }
                            token = StringUtils.trim(this.getField(fields, 0));
                            ParseAssert.notEmpty(token, 1110);
                            item.setGeocacheCode(token);
                            item.setSite(GeocacheCodeService.getInstance().getSite(token));
                            token = StringUtils.trim(this.getField(fields, 1));
                            Date date = this.dateParser.parse(token);
                            if (this.strictMode) {
                                ParseAssert.notNull(date, 1120);
                            } else if (date == null) {
                                date = new Date();
                            }
                            item.setLogDate(date);
                            token = StringUtils.trim(this.getField(fields, 2));
                            if (this.strictMode) {
                                ParseAssert.notEmpty(token, 1130);
                            } else if (StringUtils.isEmpty(token)) {
                                token = GeocacheLogType.WRITE_NOTE.text();
                            }
                            item.setLogType(logTypeMapper.getMappedValue(token, null));
                            token = StringUtils.trim(this.getField(fields, 3));
                            if (this.strictMode) {
                                ParseAssert.notEmpty(token, 1140);
                            } else if (StringUtils.isEmpty(token)) {
                                token = "\"\"";
                            }
                            if (token.startsWith("\"")) {
                                token = token.substring(1);
                            }
                            if (token.endsWith("\"")) {
                                token = token.substring(0, token.length() - 1);
                            } else {
                                cont = true;
                            }
                            item.setLogText(token);
                        }
                        if (cont) continue;
                        this.items.add(item);
                        item = this.createFieldNoteItem();
                    }
                }
                if (ur == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (ur == null) throw throwable;
                ur.close();
                throw throwable;
            }
            ur.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private String getField(String[] fields, int index) {
        if (fields != null && index >= 0 && index < fields.length) {
            return fields[index];
        }
        return null;
    }

    private FieldNoteItem createFieldNoteItem() {
        FieldNoteItem item = new FieldNoteItem();
        item.setFieldNoteType(FieldNoteType.FILE);
        return item;
    }

    public List<FieldNoteItem> getItems() {
        return this.items;
    }
}

