/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes.xml;

import geocentral.common.data.DataReaderContext;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.FieldNoteStatus;
import geocentral.common.data.FieldNoteType;
import geocentral.common.data.parsers.IAttributes;
import geocentral.common.data.parsers.UserParser;
import geocentral.common.fieldnotes.FieldNotesDateUtils;
import geocentral.common.fieldnotes.xml.FieldNoteGeocacheParser;
import geocentral.common.geocaching.GeocacheLogType;
import geocentral.common.geocaching.GeocacheSite;
import org.bacza.http.URLUtils;
import org.bacza.utils.StringUtils;

public class FieldNoteParser
extends UserParser {
    private FieldNoteItem item;

    public FieldNoteParser(DataReaderContext readerContext) {
        super(readerContext);
    }

    @Override
    public void startProcessing() {
        this.item = new FieldNoteItem();
        this.readerContext.pushItem(this.item);
    }

    @Override
    public void stopProcessing() {
        this.readerContext.popItem();
        this.readerContext.getDataStore().putItem(this.item);
    }

    @Override
    public void startElement(String name, String namespace, String uri, IAttributes attrs) {
        if ("geocache".equals(name)) {
            this.installParser(new FieldNoteGeocacheParser(this.readerContext));
        }
    }

    @Override
    public void value(String name, Object value, IAttributes attrs) {
        if ("item_type".equals(name)) {
            this.item.setFieldNoteType(FieldNoteType.valueOf(FieldNoteParser.getValueAsString(value)));
        } else if ("status".equals(name)) {
            this.item.setFieldNoteStatus(FieldNoteStatus.valueOf(FieldNoteParser.getValueAsString(value)));
        } else if ("site".equals(name)) {
            this.item.setSite(GeocacheSite.valueOf(FieldNoteParser.getValueAsString(value)));
        } else if ("date".equals(name)) {
            this.item.setLogDate(FieldNotesDateUtils.CUSTOM_PARSER.parse(FieldNoteParser.getValueAsString(value)));
        } else if ("type".equals(name)) {
            this.item.setLogType(GeocacheLogType.parse(FieldNoteParser.getValueAsString(value)));
        } else if ("comment".equals(name)) {
            this.item.setLogText(FieldNoteParser.getValueAsString(value));
        } else if ("options".equals(name)) {
            int opt = StringUtils.parseInt(FieldNoteParser.getValueAsString(value), 0);
            this.item.setFavourite((opt & 1) != 0);
            this.item.setVisitTrackables((opt & 2) != 0);
        } else if ("tag".equals(name)) {
            this.item.setTag(StringUtils.trim(FieldNoteParser.getValueAsString(value)));
        } else if ("existing_log_date".equals(name)) {
            this.item.setExistingLogDate(FieldNotesDateUtils.CUSTOM_PARSER.parse(FieldNoteParser.getValueAsString(value)));
        } else if ("existing_log_type".equals(name)) {
            this.item.setExistingLogType(GeocacheLogType.parse(FieldNoteParser.getValueAsString(value)));
        } else if ("existing_log_checked".equals(name)) {
            this.item.setExistingLogChecked(FieldNoteParser.getValueAsBoolean(value, true));
        } else if ("new_log_link".equals(name)) {
            this.item.setNewLogLink(URLUtils.create(FieldNoteParser.getValueAsString(value)));
        } else if ("compose_link".equals(name)) {
            this.item.setComposeLink(URLUtils.create(FieldNoteParser.getValueAsString(value)));
        } else if ("delete_link".equals(name)) {
            this.item.setDeleteLink(URLUtils.create(FieldNoteParser.getValueAsString(value)));
        }
    }
}

