/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes.xml;

import geocentral.common.data.DataReaderContext;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.parsers.IAttributes;
import geocentral.common.data.parsers.UserParser;
import geocentral.common.geocaching.GeocacheSize;
import geocentral.common.geocaching.GeocacheType;

public class FieldNoteGeocacheParser
extends UserParser {
    private FieldNoteItem item;

    public FieldNoteGeocacheParser(DataReaderContext readerContext) {
        super(readerContext);
    }

    @Override
    public void startProcessing() {
        this.item = (FieldNoteItem)this.readerContext.peekItem();
    }

    @Override
    public void value(String name, Object value, IAttributes attrs) {
        if ("code".equals(name)) {
            this.item.setGeocacheCode(FieldNoteGeocacheParser.getValueAsString(value));
        } else if ("guid".equals(name)) {
            this.item.setGuid(FieldNoteGeocacheParser.getValueAsString(value));
        } else if ("name".equals(name)) {
            this.item.setGeocacheName(FieldNoteGeocacheParser.getValueAsString(value));
        } else if ("owner".equals(name)) {
            this.item.setGeocacheOwner(FieldNoteGeocacheParser.getValueAsString(value));
        } else if ("type".equals(name)) {
            this.item.setType(GeocacheType.parse(FieldNoteGeocacheParser.getValueAsString(value)));
        } else if ("size".equals(name)) {
            this.item.setSize(GeocacheSize.parse(FieldNoteGeocacheParser.getValueAsString(value)));
        } else if ("diff".equals(name)) {
            this.item.setRatingDifficulty(FieldNoteGeocacheParser.getValueAsDouble(value, true));
        } else if ("terr".equals(name)) {
            this.item.setRatingTerrain(FieldNoteGeocacheParser.getValueAsDouble(value, true));
        } else if ("fav_points".equals(name)) {
            this.item.setFavPoints(FieldNoteGeocacheParser.getValueAsInt(value, true));
        } else if ("hint".equals(name)) {
            this.item.setHint(FieldNoteGeocacheParser.getValueAsString(value));
        }
    }
}

