/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes;

import geocentral.common.actions.ActionContext;
import geocentral.common.actions.AppContext;
import geocentral.common.data.DataModelUtils;
import geocentral.common.data.DataReaderContext;
import geocentral.common.data.DataStoreListAdapter;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.parsers.IUserParser;
import geocentral.common.data.parsers.ParserException;
import geocentral.common.data.parsers.XmlParser;
import geocentral.common.fieldnotes.FieldNotesDateUtils;
import geocentral.common.fieldnotes.FieldNotesFormatUtils;
import geocentral.common.fieldnotes.xml.ClipboardParser;
import geocentral.common.files.FieldNoteReader;
import geocentral.common.geocaching.GeocacheCodeService;
import geocentral.common.plugins.AppContextService;
import geocentral.common.ui.ClipboardService;
import geocentral.common.ui.DialogUtils;
import geocentral.common.ui.MessageUtils;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.data.parsers.ParseException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public final class FieldNotesClipboardUtils {
    private static final Log log = LogFactory.getLog(FieldNotesClipboardUtils.class);

    public static void setContent(List<FieldNoteItem> items) {
        if (items.size() > 0) {
            String str = FieldNotesFormatUtils.toString(items);
            String xml = FieldNotesFormatUtils.toXML(items);
            ClipboardService.getInstance().setContent(str, xml);
        }
    }

    public static boolean hasContent() {
        return false;
    }

    public static List<FieldNoteItem> getContent() {
        LinkedList<FieldNoteItem> result = new LinkedList<FieldNoteItem>();
        try {
            String data = ClipboardService.getInstance().getCustomContent();
            if (data != null) {
                FieldNotesClipboardUtils.getContentFromXML(data, result);
                return result;
            }
            data = ClipboardService.getInstance().getTextContent();
            if (data != null) {
                FieldNotesClipboardUtils.getContentFromString(data, result);
                return result;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Error processing clipboard data", (Throwable)e);
            DialogUtils.showError(MessageUtils.getMessage(e));
        }
        return result;
    }

    private static void getContentFromString(String data, List<FieldNoteItem> items) throws IOException, ParseException {
        FieldNoteReader reader = new FieldNoteReader(false, FieldNotesDateUtils.createDateParserEx());
        reader.readString(data);
        for (FieldNoteItem item : reader.getItems()) {
            if (item == null || item.getGeocacheCode() == null || !GeocacheCodeService.getInstance().isValid(item.getGeocacheCode())) continue;
            items.add(item);
        }
    }

    private static void getContentFromXML(String data, List<FieldNoteItem> items) throws IOException, ParseException {
        DataStoreListAdapter<FieldNoteItem> store = new DataStoreListAdapter<FieldNoteItem>(items);
        AppContext appContext = AppContextService.getInstance().createAppContext(null);
        DataModelUtils.setDataStore(appContext, store);
        ActionContext actionContext = new ActionContext((IProgressMonitor)new NullProgressMonitor(), appContext);
        DataReaderContext readerContext = new DataReaderContext(actionContext, store);
        ClipboardParser parser = new ClipboardParser(readerContext);
        try {
            XmlParser.parse(data, (IUserParser)parser);
        }
        catch (ParserException e) {
            throw new ParseException(e);
        }
    }
}

