/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bacza.utils.StringUtils;

public final class FieldNoteSignatureUtils {
    private static final Pattern LINE = Pattern.compile("^.*$", 8);
    private static final Pattern NON_EMPTY = Pattern.compile("\\S");
    private static final List<Pattern> SIGNATURES = new ArrayList<Pattern>();

    static {
        SIGNATURES.add(Pattern.compile("\\[.*GeoCentral.*\\]\\(.+\\)"));
        SIGNATURES.add(Pattern.compile("\\[url=.*\\].*GeoCentral.*\\[/url\\]"));
    }

    public static String stripSignature(String logText) {
        if (StringUtils.notEmpty(logText)) {
            ArrayList<MatchResult> lines = new ArrayList<MatchResult>(100);
            Matcher lineMatcher = LINE.matcher(logText);
            while (lineMatcher.find()) {
                lines.add(lineMatcher.toMatchResult());
            }
            MatchResult line = null;
            Matcher matcher = NON_EMPTY.matcher(logText);
            int i = lines.size() - 1;
            while (i >= 0) {
                line = (MatchResult)lines.get(i);
                matcher.region(line.start(), line.end());
                if (matcher.find()) break;
                --i;
            }
            if (line != null) {
                for (Pattern pattern : SIGNATURES) {
                    matcher = pattern.matcher(logText);
                    matcher.region(line.start(), line.end());
                    if (!matcher.find()) continue;
                    logText = logText.substring(0, line.start());
                    break;
                }
            }
        }
        return logText;
    }
}

