/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes;

import geocentral.common.fieldnotes.FieldNoteSignature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FieldNoteSignatureManager {
    public static final String DEFAULT_ID = "PL_01";
    public static final int MAX_LENGTH = 96;
    private static final FieldNoteSignatureManager instance = new FieldNoteSignatureManager();
    private Map<String, FieldNoteSignature> map = new LinkedHashMap<String, FieldNoteSignature>();

    public static FieldNoteSignatureManager getInstance() {
        return instance;
    }

    private FieldNoteSignatureManager() {
        this.init();
    }

    private void init() {
        String url = "https://www.geocentral.pl";
        this.addSignature(new FieldNoteSignature(DEFAULT_ID, "Zalogowano przy u\u017cyciu GeoCentral Lite", String.format("Zalogowano przy u\u017cyciu [GeoCentral Lite](%s)", "https://www.geocentral.pl")));
        this.addSignature(new FieldNoteSignature("EN_01", "Powered by GeoCentral Lite", String.format("Powered by [GeoCentral Lite](%s)", "https://www.geocentral.pl")));
        this.addSignature(new FieldNoteSignature("EN_02", "Logged using GeoCentral Lite", String.format("Logged using [GeoCentral Lite](%s)", "https://www.geocentral.pl")));
    }

    private void addSignature(FieldNoteSignature signature) {
        if (signature != null) {
            this.map.put(signature.getId(), signature);
        }
    }

    public Set<String> getIds() {
        return new HashSet<String>(this.map.keySet());
    }

    public List<FieldNoteSignature> getSignatures() {
        return new ArrayList<FieldNoteSignature>(this.map.values());
    }

    public FieldNoteSignature getSignature(String id) {
        return this.map.get(id);
    }

    public String getSignatureDesc(String id) {
        FieldNoteSignature sig = this.getSignature(id);
        if (sig != null) {
            return sig.getDesc();
        }
        return null;
    }

    public String getSignatureText(String id) {
        FieldNoteSignature sig = this.getSignature(id);
        if (sig != null) {
            return sig.getText();
        }
        return null;
    }
}

